// 6502Doc.h : interface of the C6502Doc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_6502DOC_H__0BC69E3F_3B77_11D4_AD5A_006008995E83__INCLUDED_)
#define AFX_6502DOC_H__0BC69E3F_3B77_11D4_AD5A_006008995E83__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MyCpu.h"

class C6502Doc : public CDocument
{
protected: // create from serialization only
	C6502Doc();
	DECLARE_DYNCREATE(C6502Doc)

public:
	virtual ~C6502Doc();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(C6502Doc)
	public:
	virtual void Serialize(CArchive& ar);
	//}}AFX_VIRTUAL

// Implementation
public:
   inline CMyCpu::REGS GetRegs()
   { return m_CPU.GetRegs(); }
   inline void SetRegs(CMyCpu::REGS const &regs)
   { m_CPU.SetRegs(regs); }
   inline byte * GetMemory()
   { return m_CPU.GetMem(); }
   inline byte ReadMemory(WORD pos)
   { return m_CPU.ReadMem(pos); }
   inline void WriteMemory(WORD pos, byte value)
   { m_CPU.WriteMem(pos, value); }

   void DontRun(BOOL dontrun);
   bool IsRunning();
   bool CanRun();
   bool IsDocOpen();
   void GetProgramStats(WORD *base, WORD *len=NULL);
   bool BPOnAddr(WORD pc)
   { return m_CPU.IsPCBreak(pc) || m_CPU.IsMemBreak(pc); }
   WORD GetInitAddr();
   WORD GetPlayAddr();
   CString const & DisAsm(WORD *pc, bool sizeonly=false)
   { return m_CPU.DisAsm(pc, sizeonly); }

   enum MBType
   { MB_CHANGE, MB_EQUALS
   };
   void AddPCBreak(WORD pos);
   void AddMemBreak(WORD pos, byte value, MBType op);
   void RemPCBreak(WORD pos);
   void RemMemBreak(WORD pos);
   BOOL IsPCBreak(WORD pos);
   BOOL IsMemBreak(WORD pos);
   CMapWordToPtr const & GetPCBPList()
   { return m_CPU.GetPCBPList(); }
   std::vector<CMyCpu::BPoint *> const & GetMemBPList(int *len)
   { return m_CPU.GetMemBPList(len); }

   WORD GetPC();
   void SetPC(WORD pos);

   void RunTo(WORD pos);
   void Quit();

   enum DocType { DT_NOSEFART=1, DT_BINARY };
   void SetDocType(DocType dt);
   DocType GetDocType();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
   CMyCpu   m_CPU;
   BOOL     m_bDontRun;
   bool     m_bDocOpen, m_bRunning, m_bQuitting;

   DocType  m_dtType;

   WORD     m_nInitAddr, m_nPlayAddr;

   void GetFileOffsets(WORD *loadpos, int *offset);

// Generated message map functions
protected:
	//{{AFX_MSG(C6502Doc)
	afx_msg void OnDebugStepInto();
	afx_msg void OnDebugStepOver();
	afx_msg void OnDebugRunTo();
	afx_msg void OnDebugRun();
	afx_msg void OnDebugStop();
	afx_msg void OnDebugReset();
	afx_msg void OnDebugRunToReturn();
	afx_msg void OnDebugRunInitOnce();
	afx_msg void OnDebugRunPlayOnce();
	afx_msg void OnDebugBreaks();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_6502DOC_H__0BC69E3F_3B77_11D4_AD5A_006008995E83__INCLUDED_)
