// 6502View.cpp : implementation of the C6502View class
//

#include "stdafx.h"
#include "6502.h"

#include "6502Doc.h"
#include "6502View.h"

#include "RegistersDlg.h"
#include "DumpDlg.h"
#include "SourceDlg.h"
#include "SoundRegsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// C6502View

IMPLEMENT_DYNCREATE(C6502View, CView)

BEGIN_MESSAGE_MAP(C6502View, CView)
	//{{AFX_MSG_MAP(C6502View)
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_VIEW_REGS, OnViewRegs)
	ON_COMMAND(ID_VIEW_SOURCE, OnViewSource)
	ON_COMMAND(ID_VIEW_DUMP, OnNewDump)
	ON_COMMAND(ID_DEBUG_BREAK, OnDebugBreak)
	ON_COMMAND(ID_DEBUG_SETIP, OnDebugSetIP)
	ON_COMMAND(ID_DEBUG_SETCURSOR, OnDebugSetCursor)
	ON_COMMAND(ID_DEBUG_SETCURSORINIT, OnDebugSetCursorInit)
	ON_COMMAND(ID_DEBUG_SETCURSORPLAY, OnDebugSetCursorPlay)
	ON_COMMAND(ID_VIEW_SOUNDREGS, OnViewSoundRegs)
	ON_COMMAND(ID_DEBUG_RUNTO, OnDebugRunTo)
	//}}AFX_MSG_MAP
   ON_UPDATE_COMMAND_UI_RANGE(ID_VDMENUBLOCK_FIRST, ID_VDMENUBLOCK_LAST, OnVDMenuBlockUpdate)
   ON_COMMAND_RANGE(ID_VDLGSNM_FIRST, ID_VDLGSNM_LAST, OnVDNonModalClose)
   ON_MESSAGE(ID_DUMP_CLOSED, OnDumpClose)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// C6502View construction/destruction

C6502View::C6502View()
{
   int num = ID_VDLGSNM_LAST - ID_VDLGSNM_FIRST + 1;
   for(int i=0;i<num;i++)
   {
      m_bChildsOpen[i] = false;
      m_dlgChildren[i] = NULL;
   }
}

C6502View::~C6502View()
{
   int i, num = ID_VDLGSNM_LAST - ID_VDLGSNM_FIRST + 1;
   for(i=0;i<num;i++)
   {
      delete m_dlgChildren[i];
   }
   num = m_obaDumps.GetSize();
   for(i=0;i<num;i++)
   {
      if(m_obaDumps[i]) delete m_obaDumps[i];
   }
}

/////////////////////////////////////////////////////////////////////////////
// C6502View drawing

void C6502View::OnDraw(CDC* pDC)
{
}

/////////////////////////////////////////////////////////////////////////////
// C6502View diagnostics

#ifdef _DEBUG
void C6502View::AssertValid() const
{
	CView::AssertValid();
}

void C6502View::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

C6502Doc* C6502View::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(C6502Doc)));
	return (C6502Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// C6502View message handlers

void C6502View::OnVDMenuBlockUpdate(CCmdUI *pCmdUI)
{
   bool check = false;
   UINT nID = pCmdUI->m_nID;
   C6502Doc *Doc = GetDocument();
   bool enable = Doc->IsDocOpen();

   if(enable)
   {
      if(nID >= ID_DEBUG_RESET && nID <= ID_DEBUG_BREAKS && nID != ID_DEBUG_STOP)
         enable = Doc->CanRun();
      if(enable && nID >= ID_DEBUG_SETCURSORINIT && nID <= ID_DEBUG_RUNPLAYONCE)
         enable = (Doc->GetDocType() == C6502Doc::DT_NOSEFART);
      if(enable && ((nID >= ID_DEBUG_SETIP && nID <= ID_DEBUG_SETCURSORPLAY) ||
                    nID == ID_DEBUG_BREAK))
         enable = m_bChildsOpen[ID_SOURCE_CLOSED-ID_VDLGSNM_FIRST];
      if(enable && nID == ID_DEBUG_STOP)
         enable = Doc->IsRunning();
   }

   pCmdUI->Enable(enable);
   if (nID >= ID_VDMENUBLOCK_FIRST && nID <= ID_VIEW_SOUNDREGS)
      pCmdUI->SetCheck(m_bChildsOpen[nID-ID_VDMENUBLOCK_FIRST]);
}

void C6502View::OnVDNonModalClose(UINT nID)
{
   int ind = nID - ID_VDLGSNM_FIRST;

   m_bChildsOpen[ind] = false;
   delete m_dlgChildren[ind];
   m_dlgChildren[ind] = NULL;
}

void C6502View::OnDumpClose(WPARAM wParam, LPARAM lParam)
{
   int i, len = m_obaDumps.GetSize();
   ASSERT(lParam);
   for(i=0;i<len;i++) if(m_obaDumps[i] == (CObject *)lParam) break;
   ASSERT(i<len);

   delete m_obaDumps[i];
   m_obaDumps[i] = NULL;
}

void C6502View::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
   int i, num = ID_VDLGSNM_LAST - ID_VDLGSNM_FIRST + 1;
   for(i=0;i<num;i++)
   {
      if(m_dlgChildren[i]) m_dlgChildren[i]->Update(lHint);
   }
   num = m_obaDumps.GetSize();
   for(i=0;i<num;i++)
   {
      if(m_obaDumps[i]) ((CDumpDlg *)m_obaDumps[i])->Update(lHint);
   }
}

BOOL C6502View::OnEraseBkgnd(CDC* pDC) 
{
   CRect rect;
   pDC->GetClipBox(rect);

   CBrush brush;
   brush.CreateStockObject(GRAY_BRUSH);

   pDC->FillRect(rect, &brush);
   return TRUE;
}

void C6502View::OnViewRegs() 
{
   int ind = ID_REGS_CLOSED - ID_VDLGSNM_FIRST;

   if(m_bChildsOpen[ind]) m_dlgChildren[ind]->SetFocus();
   else
   {
      CRegistersDlg *dlg = new CRegistersDlg;
      m_dlgChildren[ind] = dlg;
      dlg->Create(MAKEINTRESOURCE(IDD_REGISTERS), this);
      m_bChildsOpen[ind] = true;
      dlg->Update(UC_RESET);
   }
}

void C6502View::OnViewSource() 
{
   int ind = ID_SOURCE_CLOSED - ID_VDLGSNM_FIRST;

   if(m_bChildsOpen[ind]) m_dlgChildren[ind]->SetFocus();
   else
   {
      CSourceDlg *dlg = new CSourceDlg;
      m_dlgChildren[ind] = dlg;
      dlg->Create(MAKEINTRESOURCE(IDD_SOURCE), this);
      dlg->Update(UC_RESET);
      m_bChildsOpen[ind] = true;
   }
}

void C6502View::OnViewSoundRegs() 
{
   int ind = ID_SOUNDREGS_CLOSED - ID_VDLGSNM_FIRST;

   if(m_bChildsOpen[ind]) m_dlgChildren[ind]->SetFocus();
   else
   {
      CSoundRegsDlg *dlg = new CSoundRegsDlg;
      m_dlgChildren[ind] = dlg;
      dlg->Create(MAKEINTRESOURCE(IDD_SOUNDREGS), this);
      dlg->Update(UC_RESET);
      m_bChildsOpen[ind] = true;
   }
}

void C6502View::OnNewDump() 
{
	int i, num = m_obaDumps.GetSize();
   for(i=0;i<num;i++) if(!m_obaDumps[i]) break;
   if (i == num) m_obaDumps.Add(NULL);

   CDumpDlg *dlg = new CDumpDlg;
   m_obaDumps[i] = dlg;

   dlg->Create(IDD_MEMDUMP, this);
   dlg->Update(UC_RESET);
}

void C6502View::OnDebugBreak() 
{
   CSourceDlg *dlg = (CSourceDlg *)m_dlgChildren[ID_SOURCE_CLOSED - ID_VDLGSNM_FIRST];

   WORD pos = dlg->GetCursorPos();
   C6502Doc *doc = GetDocument();

   if(doc->IsPCBreak(pos)) doc->RemPCBreak(pos);
   else doc->AddPCBreak(pos);
   dlg->Update(UC_REPAINT);
}

void C6502View::OnDebugSetIP() 
{
   CSourceDlg *dlg = (CSourceDlg *)m_dlgChildren[ID_SOURCE_CLOSED - ID_VDLGSNM_FIRST];

   WORD pos = dlg->GetCursorPos();
   GetDocument()->SetPC(pos);
   OnUpdate(NULL, UC_REPAINT, NULL);
}

void C6502View::OnDebugSetCursor() 
{
   CSourceDlg *dlg = (CSourceDlg *)m_dlgChildren[ID_SOURCE_CLOSED - ID_VDLGSNM_FIRST];
   dlg->SetCursorPos(GetDocument()->GetPC());
}

void C6502View::OnDebugSetCursorInit() 
{
   CSourceDlg *dlg = (CSourceDlg *)m_dlgChildren[ID_SOURCE_CLOSED - ID_VDLGSNM_FIRST];
   dlg->SetCursorPos(GetDocument()->GetInitAddr());
}

void C6502View::OnDebugSetCursorPlay() 
{
   CSourceDlg *dlg = (CSourceDlg *)m_dlgChildren[ID_SOURCE_CLOSED - ID_VDLGSNM_FIRST];
   dlg->SetCursorPos(GetDocument()->GetPlayAddr());
}

void C6502View::OnDebugRunTo() 
{
   CSourceDlg *dlg = (CSourceDlg *)m_dlgChildren[ID_SOURCE_CLOSED - ID_VDLGSNM_FIRST];
   GetDocument()->RunTo(dlg->GetCursorPos());
}
