// 6502View.h : interface of the C6502View class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_6502VIEW_H__0BC69E41_3B77_11D4_AD5A_006008995E83__INCLUDED_)
#define AFX_6502VIEW_H__0BC69E41_3B77_11D4_AD5A_006008995E83__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "6502Doc.h"
#include "Resource.h"
#include "MyDialog.h"

enum UpdateCodes
{ UC_REPAINT=1, UC_RESET, UC_CLOSE
};
 
class C6502View : public CView
{
protected: // create from serialization only
	C6502View();
	DECLARE_DYNCREATE(C6502View)

// Attributes
public:
	C6502Doc * GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(C6502View)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	protected:
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~C6502View();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
   bool m_bChildsOpen[ID_VDLGSNM_LAST - ID_VDLGSNM_FIRST + 1];
   CMyDialog * m_dlgChildren[ID_VDLGSNM_LAST - ID_VDLGSNM_FIRST + 1];
   CObArray    m_obaDumps;

// Generated message map functions
protected:
   //{{AFX_MSG(C6502View)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnViewRegs();
	afx_msg void OnViewSource();
	afx_msg void OnNewDump();
	afx_msg void OnDebugBreak();
	afx_msg void OnDebugSetIP();
	afx_msg void OnDebugSetCursor();
	afx_msg void OnDebugSetCursorInit();
	afx_msg void OnDebugSetCursorPlay();
	afx_msg void OnViewSoundRegs();
	afx_msg void OnDebugRunTo();
	//}}AFX_MSG
   afx_msg void OnVDMenuBlockUpdate(CCmdUI *pCmdUI);
   afx_msg void OnVDNonModalClose(UINT nID);
   afx_msg void OnDumpClose(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in 6502View.cpp
inline C6502Doc* C6502View::GetDocument()
   { return (C6502Doc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_6502VIEW_H__0BC69E41_3B77_11D4_AD5A_006008995E83__INCLUDED_)
