// BreaksDlg.cpp : implementation file
//

#include "stdafx.h"
#include "6502.h"
#include "BreaksDlg.h"

#include "6502Doc.h"
#include "InputBox.h"
#include "MyCpu.h"
#include <vector>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBreaksDlg dialog


CBreaksDlg::CBreaksDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBreaksDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBreaksDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


BEGIN_MESSAGE_MAP(CBreaksDlg, CDialog)
	//{{AFX_MSG_MAP(CBreaksDlg)
	ON_BN_CLICKED(IDC_BREAKS_ADDPCBP, OnBreaksAddPCBP)
	ON_BN_CLICKED(IDC_BREAKS_ADDMEMBP, OnBreaksAddMemBP)
	ON_BN_CLICKED(IDC_BREAKS_REMOVE, OnBreaksRemove)
	ON_BN_CLICKED(IDC_BREAKS_REMOVEALL, OnBreaksRemoveAll)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBreaksDlg commands
void CBreaksDlg::AddToList(const BPoint &bp)
{
   CString toadd;
   
   switch(bp.type)
   {
      case BP_PC:
         toadd.Format(_T("Break on PC: %0.4X"), bp.pos);
         break;
      
      case BP_MEMEQ:
         toadd.Format(_T("Break on %0.4X == %0.2X"), bp.pos, bp.value);
         break;

      case BP_MEMCH:
         toadd.Format(_T("Break on %0.4X != %0.2X"), bp.pos, bp.value);
         break;
   }

   GetDlgItem(IDC_BREAKS_LIST)->SendMessage(LB_ADDSTRING, 0, (LPARAM)(LPCTSTR)toadd);

   int len = m_vctBreaks.size();
   m_vctBreaks.resize(len+1);
   m_vctBreaks[len] = bp;
}

/////////////////////////////////////////////////////////////////////////////
// CBreaksDlg message handlers

void CBreaksDlg::OnBreaksAddPCBP() 
{
   CInputBox dlg(_T("Enter PC to break on (hex):"), _T("Enter PC"),
                 _T("0"), CInputBox::VerifyWORD);
   dlg.DoModal();

   BPoint bp;
   bp.pos  = dlg.HtoI(dlg.m_strValue);
   bp.type = BP_PC;
   AddToList(bp);
}

void CBreaksDlg::OnBreaksAddMemBP() 
{
   C6502Doc *doc = (C6502Doc *)((CFrameWnd *)AfxGetMainWnd())->GetActiveDocument();
   CInputBox op(_T("Enter Operation (\"==\" or \"!=\"):"), _T("Enter Operation"),
                _T("!="), NULL);

   op.DoModal();
   op.m_strValue.TrimLeft();
   op.m_strValue.TrimRight();
   
   BPoint bp;

   CString def;

   if(op.m_strValue == _T("==")) bp.type = BP_MEMEQ, def = _T("0");
   else if(op.m_strValue == _T("!=")) bp.type = BP_MEMCH;
   else
   {
      MessageBox(_T("Invalid Operation!"), _T("Error"));
      return;
   }

   CInputBox pos(_T("Enter memory location to watch (hex):"), _T("Enter Location"),
                 _T("0"), CInputBox::VerifyWORD);
   pos.DoModal();
   bp.pos = pos.HtoI(pos.m_strValue);

   if(op.m_strValue == _T("!=")) def.Format("%0.2X", doc->ReadMemory(bp.pos));

   CInputBox value(_T("Enter value (hex):"), _T("Enter value"),
                   def, CInputBox::VerifyBYTE);
   value.DoModal();
   bp.value = value.HtoI(value.m_strValue);
   AddToList(bp);
}

void CBreaksDlg::OnBreaksRemove() 
{
   CWnd *wnd = GetDlgItem(IDC_BREAKS_LIST);
   
   int pos = wnd->SendMessage(LB_GETCURSEL);
   if(pos == LB_ERR) return;

   wnd->SendMessage(LB_DELETESTRING, pos);

   int len = m_vctBreaks.size()-1;
   for(;pos<len;pos++) m_vctBreaks[pos] = m_vctBreaks[pos+1];
   m_vctBreaks.resize(len);
}

void CBreaksDlg::OnBreaksRemoveAll() 
{
   GetDlgItem(IDC_BREAKS_LIST)->SendMessage(LB_RESETCONTENT);
   m_vctBreaks.resize(0);
}

BOOL CBreaksDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	C6502Doc *doc = (C6502Doc *)((CFrameWnd *)AfxGetMainWnd())->GetActiveDocument();

   BPoint mybp;

   void *dummy;
   CMyCpu::BPoint *bp;

   CMapWordToPtr const &pcbp = doc->GetPCBPList();
   POSITION pos = pcbp.GetStartPosition();
   WORD  place;

   mybp.type = BP_PC;

   while(pos)
   {
      pcbp.GetNextAssoc(pos, place, dummy);
      mybp.pos = place;
      AddToList(mybp);
   }

   int i, len;
   std::vector<CMyCpu::BPoint *> const &membp = doc->GetMemBPList(&len);
	
   for(i=0;i<len;i++)
   {
      bp = membp[i];
      if(bp->op == CMyCpu::MB_CHANGE) mybp.type = BP_MEMCH;
      else if(bp->op == CMyCpu::MB_EQUALS) mybp.type = BP_MEMEQ;
      mybp.pos   = bp->pos;
      mybp.value = bp->value;
      AddToList(mybp);
   }

   return TRUE;
}
