// DumpDlg.cpp : implementation file
//

#include "stdafx.h"
#include "6502.h"
#include "6502Doc.h"
#include "6502View.h"
#include "DumpDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDumpDlg dialog


CDumpDlg::CDumpDlg(CWnd* pParent /*=NULL*/)
	: CMyDialog(CDumpDlg::IDD, pParent)
{
   m_Font.CreateStockObject(SYSTEM_FIXED_FONT);

   HDC hdc;
   hdc = ::GetDC(AfxGetMainWnd()->m_hWnd);

   CDC dc;
   dc.Attach(hdc);

   CFont *pOldFont = dc.SelectObject(&m_Font);

   TEXTMETRIC tm;
   dc.GetTextMetrics(&tm);

   m_cxChar = tm.tmAveCharWidth;
   m_cyChar = tm.tmHeight + tm.tmExternalLeading;
   
   dc.SelectObject(pOldFont);
   dc.Detach();

   ::ReleaseDC(AfxGetMainWnd()->m_hWnd, hdc);
}


BEGIN_MESSAGE_MAP(CDumpDlg, CMyDialog)
	//{{AFX_MSG_MAP(CDumpDlg)
	ON_WM_ERASEBKGND()
	ON_WM_GETMINMAXINFO()
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_VSCROLL()
	ON_WM_NCHITTEST()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRegistersDlg overrides
void CDumpDlg::OnCancel()
{
   ((CFrameWnd *)AfxGetMainWnd())->GetActiveView()->
      PostMessage(ID_DUMP_CLOSED, 0, (LPARAM)this);
   DestroyWindow();
}

BOOL CDumpDlg::PreTranslateMessage(MSG *pMsg)
{
   return CMyDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CDumpDlg commands

void CDumpDlg::Update(LPARAM lHint)
{
   switch(lHint)
   {
      case UC_REPAINT:
      case UC_RESET:
         Invalidate(FALSE);
         break;

      case UC_CLOSE:
         OnCancel();
         break;
   }
}

CString CDumpDlg::FormatLine(byte *mem, int i)
{
   CString ret;
   if (!mem)
      ret.Format(" %0.4X  ?? ?? ?? ?? ?? ?? ?? ?? - ?? ?? ?? ?? ?? ?? ?? ??"
                 "  ........-........ ", i*16);
   else
   {
      char buf[16];
      memcpy(buf, mem += i*=16, 16);
      for(int p=0;p<16;p++) if(!isprint(buf[p])) buf[p] = '.';
      ret.Format(" %0.4X  %0.2X %0.2X %0.2X %0.2X %0.2X %0.2X %0.2X %0.2X "
                 "- %0.2X %0.2X %0.2X %0.2X %0.2X %0.2X %0.2X %0.2X  "
                 "%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",
                 i,
                 mem[0], mem[1], mem[2], mem[3], mem[4], mem[5], mem[6], mem[7],
                 mem[8], mem[9], mem[10], mem[11], mem[12], mem[13], mem[14], mem[15],
                 buf[0], buf[1], buf[2], buf[3], buf[4], buf[5], buf[6], buf[7],
                 buf[8], buf[9], buf[10], buf[11], buf[12], buf[13], buf[14], buf[15]);
   }

   return ret;
}

/////////////////////////////////////////////////////////////////////////////
// CDumpDlg message handlers

BOOL CDumpDlg::OnEraseBkgnd(CDC* pDC) 
{
   CRect rect;
   pDC->GetClipBox(rect);

   CBrush brush;
   brush.CreateStockObject(WHITE_BRUSH);

   pDC->FillRect(rect, &brush);
   return TRUE;
}

void CDumpDlg::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI) 
{
	CDialog::OnGetMinMaxInfo(lpMMI);
   int xwid = m_cxChar * 78;

   lpMMI->ptMinTrackSize.x = lpMMI->ptMaxTrackSize.x = lpMMI->ptMaxSize.x = xwid;
   lpMMI->ptMaxSize.y = GetSystemMetrics(SM_CYSCREEN) / 2;
}

void CDumpDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
   CRect rect;
   dc.GetClipBox(rect);

   CFont *pOldFont = dc.SelectObject(&m_Font);

   byte *mem = ((C6502Doc *)((CFrameWnd *)AfxGetMainWnd())->GetActiveDocument())->GetMemory();

   int start = rect.top / m_cyChar + m_nPos;
   int end = rect.bottom / m_cyChar + m_nPos;
   if (end >= 4096) end = 4095;

   int y = 0;

   CString txt;
   txt.Format("Memory dump at %0.4X", m_nPos*16);
   SetWindowText(txt);

   for(int i=m_nPos;i<=end;y+=m_cyChar,i++)
   {
      dc.TextOut(0, y, FormatLine(mem, i));
   }

   dc.SelectObject(pOldFont);
}

BOOL CDumpDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

   SetScrollPos(SB_VERT, m_nPos = 0);

	return TRUE;
}

void CDumpDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
   CRect rect;
   GetClientRect(rect);

   SCROLLINFO si;
   si.cbSize = sizeof(si);
   si.fMask  = SIF_PAGE | SIF_RANGE;
   si.nPage  = m_cyPage = rect.bottom / m_cyChar;
   si.nMin   = 0;
   si.nMax   = m_nSBEnd = 65536/16-1;
   if(m_nPos > si.nMax) m_nPos = si.nMax;
   SetScrollInfo(SB_VERT, &si);
}

void CDumpDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);

   int nDelta=0;

   switch(nSBCode)
   {
      case SB_LINEUP:   nDelta--; break;
      case SB_LINEDOWN: nDelta++; break;
      case SB_PAGEUP:   nDelta = -m_cyPage; break;
      case SB_PAGEDOWN: nDelta =  m_cyPage; break;
      case SB_TOP:      nDelta = -m_nPos;   break;
      case SB_BOTTOM:   nDelta = (m_nSBEnd-m_nPos); break;

      case SB_THUMBPOSITION:
      case SB_THUMBTRACK:
         nDelta = (WORD)nPos-m_nPos; break;
   }

   if(m_nPos + nDelta > m_nSBEnd) nDelta = m_nSBEnd-m_nPos;
   if(m_nPos + nDelta < 0) nDelta = -m_nPos;
   if(nDelta)
   {
      ScrollWindow(0, -nDelta * m_cyChar);
      SetScrollPos(SB_VERT, m_nPos += nDelta);
   }
}

UINT CDumpDlg::OnNcHitTest(CPoint point) 
{
   UINT hit = CDialog::OnNcHitTest(point);
   if(hit == HTCLIENT) hit = HTCAPTION;
   return hit;
}
