// InputBox.cpp : implementation file
//

#include "stdafx.h"
#include "6502.h"
#include "InputBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CInputBox dialog


CInputBox::CInputBox(CString const &strPrompt,  //="Enter Value:"
                     CString const &strCaption, //="Input Box"
                     CString const &strDefault, //=""
                     VERIFYFUNCT vfyFnx,        //=NULL
                     CWnd* pParent)             //=NULL
	: CDialog(CInputBox::IDD, pParent)
{
	//{{AFX_DATA_INIT(CInputBox)
	m_strValue = _T("");
	//}}AFX_DATA_INIT
   m_strCaption = strCaption, m_strPrompt = strPrompt;
   m_strDefault = strDefault;
   m_vfyFunct   = vfyFnx;
}


void CInputBox::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInputBox)
	DDX_Text(pDX, IDC_INPUT_EDIT, m_strValue);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInputBox, CDialog)
	//{{AFX_MSG_MAP(CInputBox)
	ON_EN_UPDATE(IDC_INPUT_EDIT, OnUpdateInputEdit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInputBox verify functions that you can use
CString const & CInputBox::VerifyBYTE(CString const &input)
{
   static CString ret;
   ret = input;

   int i = CheckHex(input);
   if(i != -1) ret.Replace(i, 0);

   if(HtoI(ret) > 255) ret = "FF";
   return ret;
}

CString const & CInputBox::VerifyWORD(CString const &input)
{
   static CString ret;
   ret = input;

   int i = CheckHex(input);
   if(i != -1) ret.Replace(i, 0);

   if(HtoI(ret) > 65535) ret = "FFFF";
   return ret;
}

/////////////////////////////////////////////////////////////////////////////
// CInputBox commands
int CInputBox::HtoI(CString const &str)
{
   char *Hexs = "0123456789ABCDEF";
   int ret = 0;

   for(int i=0,l=str.GetLength();i<l;i++)
   {
      ret <<= 4;
      int n = str[i];
      ret += (n >= 'A' ? n - 'A'+10 : n - '0');
   }
   return ret;
}

int CInputBox::CheckHex(CString const &input)
{
   char *Hexs = "0123456789ABCDEF";

   int i, len = input.GetLength();

   for(i=0;i<len;i++)
   {
      if(!strchr(Hexs, toupper(input[i]))) return i;
   }
   return -1;
}

/////////////////////////////////////////////////////////////////////////////
// CInputBox overrides
void CInputBox::OnCancel()
{
   MessageBeep(-1);
}

/////////////////////////////////////////////////////////////////////////////
// CInputBox message handlers

BOOL CInputBox::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
   SetWindowText(m_strCaption);
   GetDlgItem(IDC_INPUT_PROMPT)->SetWindowText(m_strPrompt);
   CWnd *wnd = GetDlgItem(IDC_INPUT_EDIT);
   wnd->SetWindowText(m_strDefault);
   wnd->SetFocus();

	return FALSE;
}

void CInputBox::OnUpdateInputEdit() 
{
   if(m_vfyFunct)
   {
      CString txt;
      CWnd *wnd = GetDlgItem(IDC_INPUT_EDIT);
      wnd->GetWindowText(txt);
      
      CString const &ret = m_vfyFunct(txt);
      if(ret != txt)
      {
         wnd->SetWindowText(ret);
         MessageBeep(-1);
      }
   }
}
