// MyCpu.h: interface for the CMyCpu class.
// Must run in main thread, and only one allowed!
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MYCPU_H__974B4721_3B81_11D4_AD5A_006008995E83__INCLUDED_)
#define AFX_MYCPU_H__974B4721_3B81_11D4_AD5A_006008995E83__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "M6502.h"
#include <vector>

class CMyCpu  
{
public:
	CMyCpu();
	virtual ~CMyCpu();

   void Run();    // run until stopped. pumps messages.
   void RunTo(WORD pos); // run to pos or until stopped. pumps messages
   void RunToReturn();   // run until function returns, pumps messages
   void StepInto();   // execute one instruction
   void StepOver();   // execute one instruction, consider subs to be one
   void Stop();   // stops the cpu
   int  Load(WORD pos, byte *data, int len);   // load the program (calls Reset too)
   void Reset();  // resets the cpu to default state (useless unless Load has been called)

   inline byte SafeReadMem(WORD pos)
   { if(pos <= 0xFFFF) return ReadMem(pos);
     else return 0;
   }
   inline byte SafeWriteMem(WORD pos, byte value)
   { if(pos <= 0xFFFF) WriteMem(pos, value);
   }
   inline byte ReadMem(WORD pos)                // read a byte
   { return M6502CPU::_Rd6502(&m_CPU, pos);
   }
   inline void WriteMem(WORD pos, byte value)   // write a byte
   { M6502CPU::_Wr6502(&m_CPU, pos, value);
   }

   inline void Push(byte value)                 // push onto stack
   { WriteMem(0x100+m_CPU.S--, value);
   }

   byte * GetMem()                              // returns 64k memory block
   { return (byte *)m_CPU.User;
   }

   struct REGS
   {
     WORD PC;
     byte A,P,X,Y,S;     /* CPU registers and program counter   */
   };
   REGS &GetRegs();
   void SetRegs(REGS const &regs);
   
   WORD GetBasePC();
   WORD GetProgLen();

   CString const & DisAsm(WORD *pos, bool sizeonly);

   enum MBType
   { MB_CHANGE, MB_EQUALS
   };
   void AddPCBreak(WORD pos);                         // sets a breakpoint on execution
   void AddMemBreak(WORD pos, byte value, MBType op); // sets a breakpoint on memory
   void RemPCBreak(WORD pos);                         // rems a breakpoint on execution
   void RemMemBreak(WORD pos);                        // rems a breakpoint on memory
   BOOL IsPCBreak(WORD pos);                          // returns true if a PC BP is on this address
   int  IsMemBreak(WORD pos);                         // returns >=0 if a Mem BP is on this address
   void ClearPCBreaks();
   void ClearMemBreaks();

   struct BPoint
   {
      WORD pos;
      byte value;
      byte op;
   };
   CMapWordToPtr const & GetPCBPList();
   std::vector<BPoint *> const & GetMemBPList(int *len);

protected:
   M6502CPU::M6502 m_CPU;
   WORD            m_BaseAddr, m_ProgLen;
   volatile bool   m_bStop;

   CMapWordToPtr   m_mapPCBP;
   std::vector<BPoint *> m_vctMemBP;
   int             m_nPCBreaks, m_nMemBreaks;
};

#endif // !defined(AFX_MYCPU_H__974B4721_3B81_11D4_AD5A_006008995E83__INCLUDED_)
