// RegistersDlg.cpp : implementation file
//

#include "stdafx.h"
#include "6502.h"
#include "6502View.h"
#include "RegistersDlg.h"

#include "6502Doc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRegistersDlg dialog


CRegistersDlg::CRegistersDlg(CWnd* pParent /*=NULL*/)
	: CMyDialog(CRegistersDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRegistersDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
   m_bModify = false;
}


BEGIN_MESSAGE_MAP(CRegistersDlg, CDialog)
	//{{AFX_MSG_MAP(CRegistersDlg)
	ON_WM_CLOSE()
	ON_WM_NCHITTEST()
	ON_BN_CLICKED(IDC_REGS_MODIFY, OnRegsModify)
	//}}AFX_MSG_MAP
	ON_COMMAND_RANGE(IDC_CHK_REG_C, IDC_CHK_REG_N, OnFlagClick)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRegistersDlg overrides
void CRegistersDlg::OnOK()
{
   if(m_bModify)
   {
      DiscardChanges();
      OnRegsModify();
   }
   else SendMessage(WM_CLOSE);
}

void CRegistersDlg::OnCancel()
{
   if(m_bModify) OnOK();
   else SendMessage(WM_CLOSE);
}

/////////////////////////////////////////////////////////////////////////////
// CRegistersDlg commands

void CRegistersDlg::Update(LPARAM lHint)
{
   switch(lHint)
   {
      case UC_REPAINT:
      case UC_RESET:
         {
            C6502Doc *doc = (C6502Doc *)((CFrameWnd *)AfxGetMainWnd())->GetActiveDocument();
            ASSERT(!m_bModify);
            SetRegs(doc->GetRegs());
         }
         break;

      case UC_CLOSE:
         SendMessage(WM_CLOSE);
         break;
   }
}

void CRegistersDlg::SetRegs(CMyCpu::REGS const &regs)
{
   m_REGS = regs;

   GetDlgItem(IDC_EDIT_REG_A)->SetWindowText(ItoH(regs.A));
   GetDlgItem(IDC_EDIT_REG_X)->SetWindowText(ItoH(regs.X));
   GetDlgItem(IDC_EDIT_REG_Y)->SetWindowText(ItoH(regs.Y));
   GetDlgItem(IDC_EDIT_REG_S)->SetWindowText(ItoH(regs.S));
   GetDlgItem(IDC_EDIT_REG_P)->SetWindowText(ItoH(regs.P));
   GetDlgItem(IDC_EDIT_REG_PC)->SetWindowText(ItoH(regs.PC,4));
   
   UpdateFlags();
}

CString CRegistersDlg::ItoH(int n,int len)
{
   CString ret;
   if (len == 2) ret.Format("%0.2X", n);
   else ret.Format("%0.4X", n);
   return ret;
}

int CRegistersDlg::HtoI(CString const &str)
{
   char *Hexs = "0123456789ABCDEF";
   int ret = 0;

   for(int i=0,l=str.GetLength();i<l;i++)
   {
      ret <<= 4;
      int n = str[i];
      ret += (n >= 'A' ? n - 'A'+10 : n - '0');
   }
   return ret;
}

void CRegistersDlg::UpdateFlags()
{
   int res = IDC_CHK_REG_C;
   CString strP;
   GetDlgItem(IDC_EDIT_REG_P)->GetWindowText(strP);
   int nP  = HtoI(strP);

   for(int i=0;i<8;res++,i++)
   {
      ((CButton *)GetDlgItem(res))->SetCheck(nP & 1);
      nP >>= 1;
   }
}

void CRegistersDlg::ApplyChanges()
{
   CMyCpu::REGS regs;
   CString txt;

   GetDlgItem(IDC_EDIT_REG_A)->GetWindowText(txt);
   regs.A  = HtoI(txt);
   GetDlgItem(IDC_EDIT_REG_X)->GetWindowText(txt);
   regs.X  = HtoI(txt);
   GetDlgItem(IDC_EDIT_REG_Y)->GetWindowText(txt);
   regs.Y  = HtoI(txt);
   GetDlgItem(IDC_EDIT_REG_S)->GetWindowText(txt);
   regs.S  = HtoI(txt);
   GetDlgItem(IDC_EDIT_REG_P)->GetWindowText(txt);
   regs.P  = HtoI(txt);
   GetDlgItem(IDC_EDIT_REG_PC)->GetWindowText(txt);
   regs.PC = HtoI(txt);
   SetRegs(regs);
}

void CRegistersDlg::DiscardChanges()
{
   SetRegs(m_REGS);
}

/////////////////////////////////////////////////////////////////////////////
// CRegistersDlg message handlers
void CRegistersDlg::OnClose()
{
   ((CFrameWnd *)AfxGetMainWnd())->GetActiveView()->
      PostMessage(WM_COMMAND, ID_REGS_CLOSED);
   DestroyWindow();
}

void CRegistersDlg::OnFlagClick(UINT nID)
{
   int mask = 1 << (nID - IDC_CHK_REG_C);

   CString txt;
   CWnd *wnd = GetDlgItem(IDC_EDIT_REG_P);
   wnd->GetWindowText(txt);
   int n = HtoI(txt);
   
   if(((CButton *)GetDlgItem(nID))->GetCheck()) n |= mask;
   else n &= ~mask;

   wnd->SetWindowText(ItoH(n));
}

UINT CRegistersDlg::OnNcHitTest(CPoint point) 
{
   UINT hit = CDialog::OnNcHitTest(point);
   if(hit == HTCLIENT) hit = HTCAPTION;
   return hit;
}

void CRegistersDlg::OnRegsModify() 
{
   C6502Doc *doc = (C6502Doc *)((CFrameWnd *)AfxGetMainWnd())->GetActiveDocument();

   if(m_bModify)
   {
      GetDlgItem(IDOK)->SetWindowText("&Ok");
      ApplyChanges();
      m_bModify = false;
   }
   else
   {
      if(doc->IsRunning())
      {
         AfxMessageBox("Can't modify while running!");
         return;
      }
      GetDlgItem(IDOK)->SetWindowText("&Discard");
      m_bModify = true;
   }
   doc->DontRun(m_bModify);

   int i;
   for(i=IDC_CHK_REG_C;i<=IDC_CHK_REG_N;i++)
   {
      GetDlgItem(i)->EnableWindow(m_bModify);
   }
   for(i=IDC_EDIT_REG_A;i<=IDC_EDIT_REG_PC;i++)
   {
       if(i != IDC_EDIT_REG_P)
         GetDlgItem(i)->SendMessage(EM_SETREADONLY, !m_bModify);
   }
}

BOOL CRegistersDlg::OnInitDialog() 
{
	CMyDialog::OnInitDialog();
	
   int i;
   for(i=IDC_EDIT_REG_A;i<=IDC_EDIT_REG_P;i++) // all except PC
   {
      GetDlgItem(i)->SendMessage(EM_LIMITTEXT, 2);
   }
   GetDlgItem(i)->SendMessage(EM_LIMITTEXT, 4); // do PC
	
	return TRUE;
}

BOOL CRegistersDlg::PreTranslateMessage(MSG *pMsg)
{
   return CMyDialog::PreTranslateMessage(pMsg);
}
