// SoundRegsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "6502.h"
#include "SoundRegsDlg.h"

#include "6502Doc.h"
#include "6502View.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSoundRegsDlg dialog


CSoundRegsDlg::CSoundRegsDlg(CWnd* pParent /*=NULL*/)
	: CMyDialog(CSoundRegsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSoundRegsDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


BEGIN_MESSAGE_MAP(CSoundRegsDlg, CDialog)
	//{{AFX_MSG_MAP(CSoundRegsDlg)
	ON_WM_NCHITTEST()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSoundRegsDlg overrides
void CSoundRegsDlg::OnCancel()
{
   ((CFrameWnd *)AfxGetMainWnd())->GetActiveView()->
      PostMessage(WM_COMMAND, ID_SOUNDREGS_CLOSED);
   DestroyWindow();
}

void CSoundRegsDlg::Update(LPARAM lHint)
{
   switch(lHint)
   {
      case UC_REPAINT:
      case UC_RESET:
         ReloadValues();
         break;

      case UC_CLOSE:
         OnCancel();
         break;
   }
}

/////////////////////////////////////////////////////////////////////////////
// CSoundRegsDlg commands
void CSoundRegsDlg::ReloadValues()
{
   C6502Doc *doc = (C6502Doc *)((CFrameWnd *)AfxGetMainWnd())->GetActiveDocument();

   for(int i=0;i<20;i++)
      GetDlgItem(IDC_SOUNDREGS_SQ11+i)->
         SetWindowText(NToB(doc->ReadMemory(0x4000+i)));
}

CString const & CSoundRegsDlg::NToB(int n)
{
   static CString ret;
   
   ret = _T("");
   for(int i=0;i<8;n>>=1,i++) ret += n&1 ? _T('1') : _T('0');

   return ret;
}

UINT CSoundRegsDlg::OnNcHitTest(CPoint point) 
{
   UINT hit = CDialog::OnNcHitTest(point);
   if(hit == HTCLIENT) hit = HTCAPTION;
   return hit;
}
