#if !defined(AFX_SOURCEDLG_H__1FA21B17_3C98_11D4_AD5A_006008995E83__INCLUDED_)
#define AFX_SOURCEDLG_H__1FA21B17_3C98_11D4_AD5A_006008995E83__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// SourceDlg.h : header file
//

#include "MyDialog.h"
#include <vector>

/////////////////////////////////////////////////////////////////////////////
// CSourceDlg dialog

class CSourceDlg : public CMyDialog
{
// Construction
public:
	CSourceDlg(CWnd* pParent = NULL);   // standard constructor
   virtual ~CSourceDlg();

// Dialog Data
	//{{AFX_DATA(CSourceDlg)
	enum { IDD = IDD_SOURCE };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA


// Overrides
public:
   virtual void Update(LPARAM lHint);

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSourceDlg)
	protected:
	//}}AFX_VIRTUAL
   virtual BOOL PreTranslateMessage(MSG *pMsg);
   virtual void OnCancel();

// Implementation
public:
   WORD  GetCursorPos();
   void  SetCursorPos(WORD pos);
   void  SetCurrentPC(WORD pos);

protected:
   CFont m_Font;
   int   m_cxChar, m_cyChar, m_cyPage;
   int   m_nPos, m_nPosPC, m_nCursor, m_nSBEnd, m_nProgTop, m_nRealPC;

   CWordArray  m_wCodeArr;
   byte       *m_pbMem, *m_pbOpData;

   bool  m_bDoDumb;
   int   m_nDumbOffset;

   void ResetSource();
   void DoDisAsm(C6502Doc *Doc, WORD pos);
   int  InCodeArr(WORD pos);
   void AddToCodeArr(WORD start, WORD end);
   void CombineRanges();
   inline bool CantContinue(WORD pos)
   { byte b = m_pbMem[pos]; return b == 0x4C || b == 0x6C || b == 0x60 || b == 0x40; }
   inline bool IsBranch(WORD pos)
   { byte b = m_pbMem[pos]; return !(b & 0x0F) && (b & 0x10); }
   inline bool IsJump(WORD pos)
   { byte b = m_pbMem[pos]; return b == 0x20 || b == 0x4C; }
   inline bool IsInRange(int v, int rs, int re)
   { return v >= rs && v <= re; }
   inline int IsValid(WORD pos)
   { byte mask = 1 << (pos & 0x07);  return m_pbOpData[(pos>>3)+0x8000] & mask; }
   inline void SetValid(WORD pos)
   { byte mask = 1 << (pos & 0x07);  m_pbOpData[(pos>>3)+0x8000] |= mask; }
   inline int ToNextOp(WORD pos)
   { byte shift = (pos & 0x03)<<1, mask = 3 << shift;
     return (m_pbOpData[(pos>>2)] & mask) >> shift;
   }
   inline int ToPrevOp(WORD pos)
   { byte shift = (pos & 0x03)<<1, mask = 3 << shift;
     return (m_pbOpData[(pos>>2)+0x4000] & mask) >> shift;
   }
   inline void SetToNextOp(WORD pos, byte value)
   { byte shift = (pos & 0x03)<<1; int i=(pos>>2);
     m_pbOpData[i] = (m_pbOpData[i] & ~(0x03 << shift)) | (value << shift);
   }
   inline void SetToPrevOp(WORD pos, byte value)
   { byte shift = (pos & 0x03)<<1; int i=(pos>>2)+0x4000;
     m_pbOpData[i] = (m_pbOpData[i] & ~(0x03 << shift)) | (value << shift);
   }
      
   void DoResize(int cx, int cy);
   int  AdvanceNLines(int numlines);
   void ScrollToCursor();
   void ScrollToPC();

	// Generated message map functions
	//{{AFX_MSG(CSourceDlg)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
	virtual BOOL OnInitDialog();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnPaint();
   afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
   afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
   afx_msg void OnContextMenu(CWnd *pWnd, CPoint pos);
	//}}AFX_MSG
   int CheckCursorMove(UINT nChar, UINT nRepCnt, UINT nFlags);
   int CheckDumbCtrls (UINT nChar, UINT nRepCnt, UINT nFlags);
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SOURCEDLG_H__1FA21B17_3C98_11D4_AD5A_006008995E83__INCLUDED_)
