/*
This software was written to control a battery charger.

http://www.adammil.net/
Copyright (C) 2009 Adam Milazzo

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef AM_BATTERY_H
#define AM_BATTERY_H

#include "types.h"

enum ChargeResult
{
  Aborted, VoltageOrTimeLimitReached, DeltaVDetected
};

// returns true if a battery has been detected
bool detectBattery();

// charges at 100% of the maximum charge level until -deltaV or voltage reaches threshold
// returns false if the battery was removed or the charge is complete
byte fastCharge();

// reads the battery voltage using the ADC
uint16 readBatteryVoltage();

// performs a basic self test, and calls errorMode() if it fails
void selfTest();

// slow charges for the given number of seconds at most.
// returns false if the battery was removed or the charge is complete
byte slowCharge();

// performs the final charge, which is a slowish charge with -deltaV. the final stage exists
// because the battery voltage tends to drop a bit after the fast charge stops. a slower charge
// may allow us to know when the battery is REALLY charged up to the voltage limit.
byte finalCharge();

// waits for the battery voltage to stabilize.
// returns false if the battery was removed or the charge is complete
bool stabilize();

// waits for an uncharged battery to be inserted
void waitForBattery();

// waits for the battery to be removed
void waitUntilBatteryRemoved();

#endif
