/*
This software was written to control a battery charger.

http://www.adammil.net/
Copyright (C) 2009 Adam Milazzo

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef AM_DELAY_H
#define AM_DELAY_H

#include "types.h"

// delays for the given number of milliseconds. this method should be used
// instead of _delay_ms when the delay time is not a compile-time constant
void dynamicDelayMs(byte ms) __attribute__((noinline));

// delays for the given number of seconds. this method should be used
// instead of _delay_ms when the delay time is not a compile-time constant
void dynamicDelaySecs(byte secs) __attribute__((noinline));

// delays in a low-power mode for the given number of milliseconds. a
// low-power delay may be less precise than a powered delay
void lowPowerDelayMs(byte ms, byte sleepMode) __attribute__((noinline));

// delays in a low-power mode for the given number of seconds. a
// low-power delay may be less precise than a powered delay
void lowPowerDelaySecs(byte secs, byte sleepMode);

// equivalent to calling lowPowerDelay with SLEEP_MODE_PWR_DOWN
void powerDownDelay100ms() __attribute__((noinline));
void powerDownDelay2secs() __attribute__((noinline));

#endif
