/*
This software was written to control a battery charger.

http://www.adammil.net/
Copyright (C) 2009 Adam Milazzo

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "battery.h"
#include "delay.h"
#include "definitions.h"
#include <avr/io.h>
#include <avr/interrupt.h>

// Information about battery charging was obtained from these sources:
// http://www.mpoweruk.com/chargers.htm
// http://www.angelfire.com/electronic/hayles/charge1.html

// AVR-LibC gets the value of PRTIM0 wrong for the ATtiny13A. This was reported as bug #2898745:
// http://sourceforge.net/tracker/?func=detail&aid=2898745&group_id=68108&atid=520074
#undef PRTIM0
#define PRTIM0 1

void main()
{
  DIDR0 = BIT(ADC0D) | BIT(ADC2D) | BIT(ADC3D) | BIT(AIN0D); // disable unused input lines
  ACSR  = BIT(ACD); // disable analog comparator
  PRR   = BIT(PRTIM0) | BIT(PRADC); // disable timer and ADC modules
  DDRB  = BIT(DDB3); // set the LED port as an output
  PORTB = BIT(PORTB1) | BIT(PORTB2); // enable pull-ups on battery type pins

  sei(); // enable interrupts

  // run a self test if no battery has been inserted
  if(!detectBattery()) selfTest();

  while(true)
  {
    waitForBattery();
    if(stabilize())
    {
      byte status = slowCharge();
      if(status == VoltageOrTimeLimitReached)
      {
        status = fastCharge();
        if(status == VoltageOrTimeLimitReached) finalCharge();
      }
      waitUntilBatteryRemoved();
    }
  }
}

