/*
This software was written to control a battery charger.

http://www.adammil.net/
Copyright (C) 2009 Adam Milazzo

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "serial.h"
#include <util/delay_basic.h>
#include <avr/io.h>

void serialSetupPort(byte port)
{
  byte mask = 1 << port;
  PORTB |= mask; // a high bit is the stop bit, so make sure the output is high
  DDRB  |= mask; // then make it an output port
}

void _serialSendChar(char c, byte port, uint16 delay)
{
  // send a start (low) bit, followed by 8 data bits, and a stop (high) bit
  byte setMask = 1 << port, clearMask = ~setMask;

  PORTB &= clearMask; // send the start bit
  _delay_loop_2(delay);

  byte bits = 8;
  do
  {
    // we send the bits in little-endian order (LSB first)
    if(c & 1) PORTB |= setMask; // send a high value if the bit is set
    else PORTB &= clearMask;    // and a low value if the bit is clear
    _delay_loop_2(delay);
    c >>= 1;
  } while(--bits);

  PORTB |= setMask; // send the stop bit
  _delay_loop_2(delay); // delay again so that we can easily send characters in succession
}

void _serialSendString(char *str, byte port, uint16 delay)
{
  while(1)
  {
    char c = *str;
    if(!c) break;
    _serialSendChar(c, port, delay);
    str++;
  }
}
