#include "watchdog.h"
#include <avr/io.h>

void disableWatchdog()
{
  __asm__ __volatile__
  (
    "cli" NLT
    "out %0, %1" NLT
    "out %0, __zero_reg__" NLT
    "sei" NLT
    "wdr"
    : /* no outputs */
    : "I" (_SFR_IO_ADDR(_WD_CONTROL_REG)),
      "r" (BIT(_WD_CHANGE_BIT) | BIT(WDE))
  );
}

/*void enableWatchdogReset(byte value)
{
  disableWatchdog();

  value = (value & 0x08 ? _WD_PS3_MASK : 0x00) | BIT(WDE) | (value & 0x07);
  __asm__ __volatile__
  (
    "in __tmp_reg__,__SREG__" NLT
    "cli" NLT
    "out %0,%1" NLT
    "out __SREG__,__tmp_reg__" NLT
    "out %0,%2"
    : // no outputs
    : "I" (_SFR_IO_ADDR(_WD_CONTROL_REG)),
      "r" (BIT(_WD_CHANGE_BIT) | BIT(WDE)),
      "r" (value)
    : "r0"
  );
}*/

void enableWatchdogInterrupt(byte value)
{
  //disableWatchdog();  skip this to save space
  _WD_CONTROL_REG = value | BIT(WDTIE);
}
