using System;
using System.IO;
using System.Threading;
using System.Windows.Forms;

namespace BuLang
{

class App
{
  static Thread windowThread;

  static void Main(string[] args)
  {
    Console.Title = "Bu's Language Console";

    windowThread = new Thread(WindowThread);
    windowThread.SetApartmentState(ApartmentState.STA);
    windowThread.Start();

    REPL();
  }

  static void REPL()
  {
    while(true)
    {
      try
      {
        Console.Write("# ");
        string line = Console.ReadLine();
        if(line == null) continue;
        line = line.Trim();
        if(line == "") continue;

        Node node = new Parser(new Scanner(new StringReader(line), "<console>")).Parse();
        object value = node.Evaluate();
        if(value != null) Console.WriteLine(Ops.ToString(value));
      }
      catch(Exception e)
      {
        Console.WriteLine("ERROR: "+e.Message);
      }
    }
  }
  
  static void WindowThread()
  {
    Application.EnableVisualStyles();
    Application.SetCompatibleTextRenderingDefault(false);
    Application.Run(new EditorForm());
  }

  static void Application_ThreadException(object sender, ThreadExceptionEventArgs e)
  {
    Console.WriteLine("THREAD ERROR: "+e.ToString());
  }
}

} // namespace BuLang