using System;
using System.Collections;

namespace Markov
{

// This is a node in a Markov chain.
public class Node : IComparable
{ public Node(string text) { Text=text; }

  // Adds a child to this node (if it doesn't exist already) and increments
  // its count and our total.
  public Node AddChild(string text)
  { Node n = GetNode(text);
    if(n==null) // if it doesn't already exist, add it
    { n = new Node(text);
      if(NumChildren==0) Children = new Node[4];
      else if(NumChildren==Children.Length)
      { Node[] narr = new Node[NumChildren*2];
        Array.Copy(Children, narr, NumChildren);
        Children = narr;
      }
      Children[NumChildren++] = n;
    }
    n.Count++; Total++; // increment counts
    return n;
  }
  
  // these two methods allow a Node to be used in standard collections
  public int CompareTo(object obj)
  { return Text.CompareTo(((Node)obj).Text);
  }
  public override int GetHashCode() { return Text.GetHashCode(); }

  // returns the child with the given text, or null if there is no such child
  public Node GetNode(string text)
  { Node n = null;
    for(int i=0; i<NumChildren; i++)
      if(Children[i].Text==text) { n=Children[i]; break; }
    return n;
  }
  
  // returns a random child node, taking into account word probabilities
  public Node RandomNode()
  { if(NumChildren==0) return null;
    int n = Rand.Next(Total);
    while(n>0)
    { n -= Children[randIndex].Count;
      if(++randIndex>=NumChildren) randIndex=0;
    }
    return Children[randIndex];
  }

  public Node[] Children;
  public string Text;
  public int    Count, NumChildren, Total;
  
  int randIndex;

  static Random Rand = new Random();
}

} // namespace Markov