.386

locals @@

segment code use16
assume CS:code,DS:code
org 7C00h

start:
jmp short bootstrap  ; jump to bootstrap
nop

; disk info
db ' AdamOS '     ; OEM Name String
dw 512            ; Bytes per sector
db 1              ; sectors per cluster
dw 0              ; reserved sectors
db 1              ; number of FATs
dw 0              ; number of root dir. entries
dw 2880           ; total number of sectors
db 0F0h           ; media descriptor byte
dw 9              ; sectors per FAT
Sectors_Per_Track dw 18
Number_Of_Heads   dw 2
dw 0              ; number of hidden sectors
db 9 dup (0)      ; unknown
dd 87654321h      ; volume serial number (reverse order)
db 'AdamOS Boot'  ; volume name
db 'AOS FAT2'     ; fat description string

Boot_Drive           EQU 0 ; floppy A
Boot_Sects           EQU 5 ; length of OS / 512 rounded up
bootstrap:
cli                        ; disable interrupts while we set up the stack

push  cs
pop   ax
mov   ds,   ax             ; ds = cs
mov   es,   ax             ; es = cs

                           ; set up stack.. 32k block at top of memory
mov   ax,   9800h          ; ax = 9800
mov   ss,   ax             ; ss = FFFF
mov   sp,   7FFCh          ; sp = 7FFC (dword aligned)
sub   bp,   bp

mov   dl, Boot_Drive       ; dl = A drive
mov   eax, 1               ; starting from sector 1
mov   cx, Boot_Sects       ; read number of sectors for OS
mov   bx, 600h
mov   es, bx
mov   bx, 0

@@readloop:
test  cx,   cx
je    @@doneread
push  cx
call Read_Sectors
pop   cx
jc    ReadError            ; error reading
sub   cl,   al
sub   ah,   ah             ; update pointer
shl   ax,   9
add   bx,   ax
jmp   @@readloop

@@doneread:

db    0EAh                 ; jump to start of OS
dw    000h
dw    600h

ReadError:
mov si, offset ErrorString ; load si with error string
call WriteString           ; write the error string
mov ax, 0                  ; ax = 0
int 16h                    ; wait for keypress
int 19h                    ; reload bootstrap

; Read_Sectors reads a number of sectors from a drive
; Drive is 00h - 7Fh for floppy, 80h - FFh for hard drive
; Number of Sectors is 0-127
; DL = Drive, EAX = sector number, CX = number of sectors, ES:BX = buffer
; first sector is 0
; Sector = AbsSector % Sectors_Per_Track + 1
; Head   = (AbsSector / Sect_Per_Track) % Number_Of_Heads
; Track  = (AbsSector / Sect_Per_Track) / Number_Of_Heads

Read_Sectors:
push  bp
push  cx       ; save number of sectors
push  bx       ; save buffer offset
push  dx       ; save drive
mov   bp,   3  ; 3 tries

sub   edx,   edx  ; edx = 0
mov   ebx,   edx  ; ebx = 0
mov   bx,    ds:[Sectors_Per_Track]
div   ebx        ; eax = AbsSect / Sect_p_Track; edx = AbsSect % Sect_p_Track
mov   cx,    dx  ;
inc   cx         ; cx = Bios Sector

sub   edx,   edx ; ready for another divide (edx = 0)
mov   ebx,   edx ; ebx = 0
mov   bx,    ds:[Number_Of_Heads]
div   ebx        ; edx = Bios Head eax = Bios Track
mov   bx,    dx  ; bx  = Bios Head

mov   dx,    ax  ; dx  = copy of track
shr   dx,    2
and   dl,    11000000b ; dl = part of track ready to be added to CL
add   cl,    dl  ; cl = sector and part of track
mov   ch,    al  ; ch = other part of track

pop   dx         ; dl = drive
mov   dh,    bl  ; dh = head

pop   bx         ; bx = buffer offset
@@retry:
pop   ax         ; al = number of sectors to read
push  ax
mov   ah,    02h ; ah = 02h (read sector function of int 13h)
int   13h
jc    @@error
pop   bp
pop   bp
ret

@@error:
dec   bp
jz    @@fail
push  ax
push  dx
sub   ax,   ax
sub   dx,   dx
int   13h
pop   dx
pop   ax
jmp   @@retry
@@fail:
pop   bp
pop   bp
ret
; carry flag = set on error
; if error, ah = error

; WriteString writes the ASCIIZ string at DS:SI to the screen
WriteString:
mov al, [si]
cmp al, 0
jz short EndString
mov ah, 0Eh
int 10h
inc si
jmp short WriteString
EndString:
ret

ErrorString db 0dh, 0ah, 'Error loading AdamOS. Press any key.', 0dh, 0ah, 0

ends
end start

