ALIGN 4
FFWildCard  db 26 dup(0)
FFDir       dw 0
CurrentDir  dw 0     ; Current directory
FFAttr      db 0


; FileClose - closes a file
; INPUT:
; DX - file handle
; OUTPUT:
; Carry set on error
; file is closed if no error
FileClose:
push  es
push  ax

mov   ax,   dx
call  GetFileBlock
jc    @@return
call  ValidFileBlock
jc    @@return

cmp   [(FileHead PTR es:bx).Entry],    FATCANUSE
jne   @@close                          ; if it's not the root just close it

push  bx
push  ecx

sub   ecx,  ecx                        ; seek to the beginning of the file
call  FileSeek

add   bx,   4                          ; read from Length
mov   cl,   4                          ; read 4 bytes
call  FileWrite
jc    @@return

pop   ecx
pop   bx

@@close:
call  CloseFileHandle

@@return:
pop   ax
pop   es
ret


; FileRead - reads a number of bytes from a file into memory
; INPUT:
; ES:BX - buffer to read into
; ECX   - number of bytes to read
; DX    - file handle
; OUTPUT:
; ECX   - number of bytes read (even if an error occured)
; Carry set on error (eof, etc)
;
PROC  FileRead  NEAR
LOCAL total:DWORD =stack_size
STACKFRAME
push  ds
push  es
pushad

mov   [total], 0h                            ; total = 0;

test  ecx,  ecx                              ; cant read 0 bytes
jz    short @@return

mov   ax,   dx
push  es
push  bx
call  GetFileBlock                           ; ds:bx = file block
push  es                                     ; es:di = dest buffer
pop   ds                                     ; ds:si = file buffer
mov   si,   bx
add   si,   FILEHEADSIZE
pop   di
pop   es
jc    @@error


mov   edx,  ecx                              ; tryread = bytes;
mov   ecx,  [(FileHead PTR bx).Length]
sub   ecx,  [(FileHead PTR bx).Pointer]      ; if (tryread > filelen-readpos)
cmp   edx,  ecx                              ; {
jbe   @@001                                  ;    tryread = filelen - readpos;
test  ecx,  ecx                              ;  if(!tryread) return 0 && error;
jz    @@error                                ; }
mov   edx,  ecx
@@001:

@@loopstart:                                 ; while(tryread)
cmp   edx,  0                                ; {
je    @@loopend

mov   eax,  [(FileHead PTR bx).Pointer]
mov   ecx,  eax
shr   eax,  9
push  es                                     ;    save es
push  ds                                     ;    es:bx = file block
pop   es
call  UpdateFileCache                        ;    CacheBlock(readptr/512);
pop   es                                     ;    restore es

mov   eax,  512
and   ecx,  01FFh
push  si
add   esi,  ecx
sub   eax,  ecx
mov   ecx,  edx                              ;    toread = tryread;
cmp   ecx,  eax                              ;    if (toread>512-readptr%512)
jbe   @@memcpy                               ;       toread = 512-readptr%512;
mov   ecx,  eax
@@memcpy:
call  CopyMemory                             ;  memcpy(buf, file.buf, toread);
pop   si
add   edi,  ecx                              ;    buf += toread;
add   [(FileHead PTR bx).Pointer],  ecx      ;    readptr += toread;
add   [total], ecx                           ;    total += toread;
sub   edx,   ecx                             ;    tryread -= toread;
jc    @@return                               ;    if (error) return error;
jmp   @@loopstart                            ; }
@@loopend:
clc
jmp   @@return

@@error:
stc
@@return:
popad
mov   ecx,  [total]
pop   es
pop   ds
ENDSTACKFRAME
ret
ENDP  FileRead


; FileWrite - writes a number of bytes to a file from memory
; INPUT:
; ES:BX - buffer to read from
; ECX   - number of bytes to write
; DX    - file handle
; OUTPUT:
; ECX   - number of bytes written (valid even if an error occured)
; Carry set on error (no free space, write error, etc )
;
PROC  FileWrite  NEAR
LOCAL total:DWORD =stack_size
STACKFRAME
push  ds
push  es
pushad

test  ecx,  ecx                              ; cant read 0 bytes
jz    short @@return

mov   [total], 0h                            ; total = 0;
mov   ax,   dx
push  es                                     ; ds:si = source buffer
pop   ds
mov   si,   bx
call  GetFileBlock                           ; es:bx = file block
jc    @@error
mov   di,   bx
add   di,   FILEHEADSIZE                     ; es:di = file buffer

test  [(FileHead PTR es:bx).Attr],  1        ; test writeable flag
jz    @@error                                ; it's read-only! so return error

mov   edx,  ecx

@@loopstart:                                 ; while(trywrite)
cmp   edx,  0                                ; {
je    @@loopend

mov   eax,  [(FileHead PTR bx).Pointer]
mov   ecx,  eax
shr   eax,  9
call  UpdateFileCache                        ;    CacheBlock(writeptr/512);
or    [(FileHead PTR bx).Attr], 1000b        ; this block is dirty now

mov   eax,  512
and   ecx,  01FFh
push  di
add   edi,  ecx
sub   eax,  ecx
mov   ecx,  edx                              ;  towrite = trywrite;
cmp   ecx,  eax                              ;  if (towrite>512-writeptr%512)
jbe   @@memcpy                               ;     towrite = 512-writeptr%512;
mov   ecx,  eax
@@memcpy:
call  CopyMemory                             ; memcpy(buf, file.buf, towrite);
pop   di
add   edi,  ecx                              ;    buf += towrite;
add   [(FileHead PTR bx).Pointer], ecx       ;    writeptr += towrite;
add   [total], ecx                           ;    total += towrite;
sub   edx,   ecx                             ;    trywrite -= towrite;
jc    @@return                               ;    if (error) return error;
jmp   @@loopstart                            ; }
@@loopend:
clc
jmp   @@return

@@error:
stc
@@return:
mov   ecx,  [(FileHead PTR bx).Pointer]
cmp   ecx,  [(FileHead PTR bx).Length]
jb    @@dontgrow
mov   [(FileHead PTR bx).Length],   ecx
@@dontgrow:
popad
mov   ecx,  [total]
pop   es
pop   ds
ENDSTACKFRAME
ret
ENDP  FileWrite


; FileLength - returns the length of a file
; INPUT:
; DX - file handle
; OUTPUT:
; Carry set on error
; ECX - file length
;
FileLength:
push  es
push  bx

xchg  ax,   dx
call  GetFileBlock
xchg  ax,   dx
jc    @@return
call  ValidFileBlock
jc    @@return

mov   ecx,  [(FileHead PTR es:bx).Length]

@@return:
pop   bx
pop   es
ret


; FileTell - returns the file pointer in a file
; INPUT:
; DX - file handle
; OUTPUT:
; Carry set on error
; ECX - read/write pointer position
;
FileTell:
push  es
push  bx

xchg  ax,   dx
call  GetFileBlock
xchg  ax,   dx
jc    @@return
call  ValidFileBlock
jc    @@return

mov   ecx,  [(FileHead PTR es:bx).Pointer]

@@return:
pop   bx
pop   es
ret


; FileSeek - seeks to a new position within a file
; INPUT:
; DX  - file handle
; ECX - position to seek to
; OUTPUT:
; Carry set on error
;
FileSeek:
push  es
push  bx

xchg  ax,   dx
call  GetFileBlock
xchg  ax,   dx
jc    @@return
call  ValidFileBlock
jc    @@return

cmp   ecx,  [(FileHead PTR es:bx).Length]
jae   @@error
mov   [(FileHead PTR es:bx).Pointer],   ecx
jmp   @@return

@@error:
stc
@@return:
pop   bx
pop   es
ret


; RenameFile - renames a file
; INPUT:
; DS:SI - original file name with optional path
; ES:DI - new name
; OUTPUT:
; Carry set on error
;
RenameFile:
push  bp
mov   bp,   sp
push  ax
call  StrLen
add   ax,   58
test  ax,   1
jz    @@even
inc   ax
@@even:
sub   sp,   ax
push  bp
mov   bp,   sp
push  ds
pusha
push  ecx
push  es
push  di

push  ss                            ; es:di -> path[]
pop   es
mov   di,   bp
add   di,   58
call  StrCpy                        ; StrCpy(path, fn);
push  es                            ; ds:si -> path[], es:di -> file[25]
pop   ds
mov   si,   di
mov   di,   bp
add   di,   32
call  SplitPathFile                 ; Split(path, file);
xchg  di,   si                      ; ds:si -> file[25], es:di -> path[]
call  ValidFileName
jc    short @@error
pop   si                            ; ds:si -> newname
pop   ds
call  ValidFileName
jc    short @@error
push  ds                            ; save newname
push  si
mov   si,   di                      ; ds:si -> path[]
push  es
pop   ds
call  OpenPath
jc    @@error
sub   si,   26                      ; ds:si -> file[25]
call  FindAndOpenFile
jc    @@seekstart
xchg  ax,   dx
call  FileClose
xchg  ax,   dx
call  FileClose
jmp   @@error
@@seekstart:
call  SeekDirStart
jc    @@error
sub   ecx,  ecx
mov   bx,   bp                   ; es:bx -> buf[32]
                                 ; ds:si -> file[25]
@@findloop:
mov   cl,   32
call  FileRead
jc    @@error
cmp   cl,   32
jne   @@error
cmp   [(DirEntry PTR es:bx).Entry], FATEMPTY
je    @@findloop
call  StrCmp
jc    @@findloop
mov   di,   bp
add   di,   7                    ; es:di -> buf.name
pop   si                         ; ds:si -> newname
pop   ds
call  StrCpy
call  FileTell
sub   ecx,  32
call  FileSeek
mov   cl,   32
call  FileWrite
jc    @@error
cmp   cl,   32
jne   @@error
call  FileClose
clc
@@return:
pop   ds
popa
pop   ecx
pop   sp
pop   bp
ret
@@error:
stc
jmp   @@return


; CreateDir - creates a directory
; INPUT:
; DS:SI - new directory name with optional path
; OUTPUT:
; Carry set on error
; else directory is created
;
CreateDir:
push  bp
mov   bp,   sp
push  ax
call  StrLen
add   ax,   58
test  ax,   1
jz    @@even
inc   ax
@@even:
sub   sp,   ax
push  bp
mov   bp,   sp
push  ds
push  es
pusha
push  ecx

push  ss                            ; es:di -> path[]
pop   es
mov   di,   bp
add   di,   58
call  StrCpy                        ; StrCpy(path, fn);
push  es                            ; ds:si -> path[], es:di -> file[25]
pop   ds
mov   si,   di
mov   di,   bp
add   di,   32
call  SplitPathFile                 ; Split(path, file);
xchg  di,   si                      ; ds:si -> file[25], es:di -> path[]
call  ValidFileName
jc    @@error
xchg  di,   si                      ; ds:si -> path[], es:di -> file[25]
call  OpenPath
jc    @@error
mov   si,   di                      ; ds:si -> file[25]
call  FindAndOpenFile               ; if (f=FindOpen(dir, file))
jc    @@seekstart                   ; {
mov   dx,   ax                      ;    fclose(f);
call  FileClose                     ;    return error;
jmp   @@error                       ; }
@@seekstart:
call  DirSeekStart
jc    @@error
sub   ecx,  ecx
mov   al,   10000b                  ; directory flag set
call  CreateFile
jc    @@error
mov   si,   bp                      ; ds:si -> buf[32]
call  GetFileBlock
mov   cx,   [(FileHead PTR es:bx).Entry]
mov   [(DirEntry PTR si).Entry], cx
xchg  ax,   dx                      ; writing to new file
mov   cl,   32
call  FileWrite
jc    @@error
cmp   cl,   32
jne   @@error
call  FileClose                     ; fclose(dir);
xchg  ax,   dx
call  FileClose                     ; fclose(f);
clc
@@return:
pop   ecx
popa
pop   es
pop   ds
pop   sp
pop   bp
ret
@@error:
stc
jmp   @@return


; ChangeDir - changes default directory
; INPUT:
; DS:SI - path string
; OUTPUT:
; Carry set on error
; current directory is changed if no error occurs
;
ChangeDir:
push  dx
call  OpenPath
jc    @@return
push  dx
mov   dx,   [CurrentDir]
call  FileClose
pop   dx
mov   [CurrentDir],  dx
clc
@@return:
ret


; SetFindFile - sets up the FindNextFile function
; INPUT:
; DS:SI - wildcard string and optional path
; AL    - attributes [xxxdahrs (directory, archive, hidden, readonly, system)]
;         files with any of the specified attributes are returned
; OUTPUT:
; Carry set on error
;
SetFindFile:
push  bp
mov   bp,   sp
mov   [FFAttr],   al
push  ax
call  StrLen
add   ax,   26
test  ax,   1
jz    @@even
inc   ax
@@even:
sub   sp,   ax
push  bp
mov   bp,   sp
push  ds
push  es
pusha

push  ss                            ; StrCpy(path, fn);
push  ss
pop   es
mov   di,   bp
add   di,   25
call  StrCpy
mov   si,   bp                      ; ds:si -> path[], es:di -> wc[25]
pop   ds
xchg  di,   si
call  SplitPathFile
mov   dx,   [FFDir]
test  dx,   dx
jz    @@open
call  FileClose
@@open:
call  OpenPath                      ; FFDir = OpenPath()
mov   [FFDir], dx
jc    @@return
xchg  di,   si                      ; FFWildcard = wc
call  StrCpy
clc
@@return:
popa
pop   es
pop   ds
pop   sp
pop   bp
ret


; FindNextFile - finds the next file that matches the specs set up with
;                SetFindFile
; INPUT:
; ES:DI - buffer to store filename (25 byte min)
; OUTPUT:
; AL    - file attributes
; buffer holds matching filename or empty string if none found (or error)
;
FindNextFile:
push  bp
mov   bp,   sp
sub   sp,   32
push  bp
mov   bp,   sp
pusha
push  ecx
push  es
push  di
mov   dx,   [FFDir]  ; dx = FFDir, ecx = 0, es:bx -> buf[32], al = FFAttr
sub   ecx,  ecx      ; es:di -> buf.name  ds:si -> FFWildCard
push  ss
pop   es
mov   bx,   bp
mov   di,   bp
mov   al,   [FFAttr]
add   di,   7
push  cs
pop   ds
mov   si,   offset   FFWildCard
@@findloop:
mov   cl,   32
call  FileRead
jc    @@none
cmp   cl,   32
jne   @@none
cmp   [(DirEntry PTR es:bx).Entry], FATEMPTY
je    @@findloop
test  al,   [(DirEntry PTR es:bx).Attr]
jz    @@findloop
call  WildcardMatch
jc    @@findloop
push  es
pop   ds
mov   si,   di
pop   di
pop   es
call  StrCpy
@@return:
pop   ecx
popa
pop   sp
pop   bp
ret
@@none:
pop   di
pop   es
mov   [byte es:di],  0h
jmp   @@return


; ----------------------------------------------------------------------------
; OpenFileRaw - opens a file using its FAT entry
; INPUT:
; DX - fat entry
; OUTPUT:
; Carry set on error
; AX - file handle
;
OpenFileRaw:
push  es
push  bx

call  OpenFileHandle                      ; open the file
jc    @@return

call  GetFileBlock                        ; get the address of the file block
jc    @@return

mov   [(FileHead PTR es:bx).Attr],  1b    ; writeable flag set
cmp   dx,   FATCANUSE                     ; is this the root dir?
jne   @@return                            ; nope, so we're done!

mov   [(FileHead PTR es:bx).Directory],   FATEMPTY ; root has no prev. dir.
push  ecx
add   bx,   4                             ; read into Length
sub   ecx,  ecx                           ; ecx = 4 bytes to read
mov   cl,   4
xchg  ax,   dx                            ; dx = file handle
call  FileRead                            ; read the length
xchg  ax,   dx
pop   ecx

@@return:
pop   bx
pop   es
ret


; CreateFile - creates a file in the given directory with the given attributes
; INPUT:
; AL    - attributes
; DX    - directory
; DS:SI - filename
; OUTPUT:
; Carry set on error
; else file is created and Directory is seeked to entry created
; AX - file
;
CreateFile:
push  bp
mov   bp,   sp
sub   sp,   32
push  bp
mov   bp,   sp
push  es
pusha
push  ecx
mov   cl,   32
call  DirSeekStart
jc    @@error
sub   ecx,  ecx

push  ss
pop   es
mov   bx,   bp
@@findloop:
mov   cl,   32
call  FileRead
cmp   cl,   32
je    @@checkused
call  FileLength
call  FileSeek
jmp   @@loopend
@@checkused:
cmp   [(DirEntry PTR es:bx).Entry], FATEMPTY
jne   @@findloop
call  FileTell
sub   ecx,  32
call  FileSeek
@@loopend:
sub   ecx,  ecx
mov   [(DirEntry PTR es:bx).Length],   ecx
mov   [(DirEntry PTR es:bx).Attr],     al
call  FindFreeFAT
jc    @@error
mov   dx,   FATEOF
call  WriteFATEntry
mov   di,   bx
add   di,   7
call  StrCpy
mov   cl,   32
call  FileWrite
cmp   cl,   32
jne   @@error
call  FindAndOpenFile

@@return:
pop   ecx
popa
pop   es
pop   sp
pop   bp
ret
@@error:
sub   ax,   ax
stc
jmp   @@return


; FindAndOpenFile - takes an open directory handle and a file name, and
;                   if the file exists in the directory, it is opened
;                   if filename is ".", ax is set to dx and no error is ret'd
;                   but directory is not opened twice.  an error is returned
;                   if DX is not a directory, unless filename is "/" in which
;                   case, the root is opened and returned. does not check the
;                   validity of the file name.
; INPUT:
; DX - directory handle
; DS:SI - file name
; OUTPUT:
; Carry set on error
; AX - file handle, 0 on error, DX if DS:SI --> "."
;
FindAndOpenFile:
push  es
push  bx
push  di
push  ecx
push  sp
sub   sp,   32

push  cs                            ; trying to open "." ?
pop   es
mov   di,   offset   szDirCurrent
call  StrCmp
jc    @@checkroot
mov   ax,   dx
jmp   @@return

@@checkroot:
mov   di,   offset   szDirRoot      ; trying to open "\"
call  StrCmp
jc    @@checkprev
mov   dx,   FATCANUSE
jmp   @@openprev

@@checkprev:
mov   di,   offset   szDirPrevious  ; trying to open ".." ?
call  StrCmp
jc    @@push0                       ; push 0 if regular search
push  1                             ; push 1 if opening ".."
jmp   @@openblock                   
@@push0:
push  0

@@openblock:
mov   ax,   dx                      ; es:bx = file block of directory
call  GetFileBlock
pop   ax                            ; ax = ".." flag
jc    @@error
call  ValidFileBlock
jc    @@error
test  [(FileHead PTR es:bx).Attr],  1000b ; if not a directory, error!
jz    @@error

sub   ecx,  ecx

test  ax,   ax                      ; ax = regular search?
jz    @@regsearch                   ; yep, do a search
cmp   [(FileHead PTR es:bx).Entry], FATCANUSE   ; already at root?
je    @@error                       ; cant go up then!
mov   dx,   [(FileHead PTR es:bx).Directory]    ; dx = previous dir.
@@openprev:
call  OpenFileRaw                   ; attempt to open it
jc    @@error
cmp   dx,   FATCANUSE               ; is prev the root?
jne   @@dotdotnot                   ; dot dot not root! :)
mov   dx,   ax
call  GetFileBlock
or    [(FileHead PTR es:bx).Attr],  1000b    ; set directory flag
jmp   @@return

@@dotdotnot:
push  ss                            ; es:bx = directory entry block
pop   es
mov   bx,   sp
mov   dx,   ax                      ; dx = file handle
call  FileSeek                      ; seek to pos 0 (1st dir entry points to
                                    ; previous directory)
mov   cl,   32                      ; read 32 bytes
call  FileRead
jc    short @@error
cmp   cl,   32                      ; read it all?
jne   short @@error
mov   dx,   [(DirEntry PTR es:bx).Entry]
call  GetFileBlock                  ; es:bx = prev dir file block
mov   [(FileHead PTR es:bx).Directory],   dx ; set prev dir for file block
or    [(FileHead PTR es:bx).Attr],  1000b    ; set directory flag
jmp   @@return                      ; handle is in ax, return it

@@regsearch:
mov   cl,   32
cmp   [(FileHead PTR es:bx).Entry],    FATCANUSE      ; is this the root dir?
jne   @@seek32                         ; if root dir, seek to pos 4
mov   cl,   4                          ; else seek to pos 32
@@seek32:
call  FileSeek
jc    @@error

push  ss                               ; es:bx = directory entry block
pop   es
mov   bx,   sp
mov   di,   sp                         ; es:di = filename
add   di,   7

@@findloop:
mov   cl,   32                         ; read 32 bytes
call  FileRead
jc    @@error
cmp   cl,   32                         ; did we read 32 bytes??
jne   @@error                          ; nerp, error..
mov   ax, [(DirEntry PTR es:bx).Entry]
mov   cl, [(DirEntry PTR es:bx).Attr]  ; save file flags
push  cx
cmp   ax, FATEMPTY                     ; if this is empty, continue
je    @@findloop
call  StrCmp                           ; compare the filenames
jc    @@findloop                       ; different, continue
@@openit:                              ; open file entry in AX
push  dx                               ; save dir entry
mov   dx,   ax                         ; dx = file entry
call  OpenFileRaw                      ; try to open file
jc    @@error                          ; error opening
mov   ecx,  [(DirEntry PTR es:bx).Length]       ; ecx = file length
call  GetFileBlock                     ; es:bx = file block of opened file
pop   dx                               ; dx = dir entry again
mov   [(FileHead PTR es:bx).Length],      ecx   ; set Length field
mov   [(FileHead PTR es:bx).Directory],   dx    ; set Directory field
pop   cx                               ; restore file flags
test  cl,   1000b                      ; is this a directory?
jz    @@success                        ; no, we're done
or    [(FileHead PTR es:bx).Attr],  1000b       ; set directory flag

@@success:
clc

@@return:
pop   sp
pop   ecx
pop   di
pop   bx
pop   es
ret
@@error:
stc
sub   ax,   ax
jmp   @@return


; WildcardMatch - case sensitive wildcard match
; INPUT:
; DS:SI - address of wildcard
; ES:DI - address of string
; OUTPUT:
; Carry flag set if strings dont match
;
WildcardMatch:
push  ax
push  di
push  si

; al - wc
; ah - sc

@@loopstart:               ; while(TRUE)
                           ; {
mov   al,   [si]           ;    wc = *wildcard++;
inc   si                   ;    switch(wc)
                           ;    {
cmp   al,   '?'            ;       case '?':
jne   @@checkstar
mov   ah,   [di]           ;          sc = *str++;
inc   di
cmp   ah,   0              ;          if (!sc) return NOTMATCH;
jne   @@loopstart          ;          break;
stc
jmp   @@return

@@checkstar:               ;       case '*':
cmp   al,   '*'
jne   @@checkdef
mov   al,   [si]           ;          wc = *wildcard++;
inc   si
cmp   al,   0              ;          if(!wc) return MATCH;
jne   @@advance
clc
jmp   @@return
@@advance:                 ;          while(str = strchr(str, wc))
mov   ah,   [di]           ;          {
inc   di                   ;             str++; 
cmp   ah,   0
je    @@fail
cmp   ah,   al
jne   @@advance
call  WildcardMatch        ;             if (Match(wildcard, str) == MATCH)
jnc   @@return             ;                return MATCH;
jmp   @@advance            ;          }
@@fail:                    ;          return NOTMATCH;
stc
jmp   @@return

@@checkdef:                ;       default:
mov   ah,   [di]           ;          sc = *str++;
inc   di
cmp   al,   ah             ;          if (wc != sc) return NOTMATCH;
je    @@checkwc
stc
jmp   @@return
@@checkwc:                 ;          if (!wc) return MATCH;
cmp   al,   0              ;    }
jne   @@loopstart          ; }
clc
jmp   @@return

@@return:
pop   si
pop   di
pop   ax
ret


; SplitPathFile - splits a pathname/filename into a pathname and a filename
; INPUT:
; DS:SI - pathname/filename
; ES:DI - buffer to put filename into (at least 25 bytes)
; OUTPUT:
; DS:SI - pathname (either can be empty)
; ES:DI - filename
;
SplitPathFile:
push  ax
push  si
push  di

sub   di,   di
mov   al,   '/'                              ; finding the last '/' in ds:si
@@lastslashloop:
call  StrChr
jc    @@endlslashloop
mov   di,   si
inc   si
jmp   @@lastslashloop

@@endlslashloop:
                        ; di = 0 if no slashes found else index of last slash
test  di,   di                               ; were any slashes found?
jnz   @@foundslash                           ; yes, so jump
pop   di                                     ; es:di = filename buffer
pop   si                                     ; ds:si = filename
push  si                                     ; need this...
jmp   @@docopy

@@foundslash:
inc   di                                     ; di = start of filename
mov   si,   di                               ; ds:si = start of filename
pop   di                                     ; es:di = filename buffer

@@docopy:
push  ecx
sub   ecx,  ecx
mov   cl,   24
call  CopyMemory                             ; copy filename into buffer
pop   ecx
mov   [byte es:di+24],     0h                ; null terminate filename
mov   [byte si],     0h                      ; null terminate pathname
pop   si                                     ; restore si
pop   ax                                     ; restore ax
ret


; ValidPathName - checks if the given string is a valid path.. not containing
;                 * ? \ , control characters or high ascii characters but
;                 doesnt check length of tokens
; INPUT:
; DS:SI - path string
; OUTPUT:
; Carry set if invalid
;
ValidPathName:
push  ax
push  di

mov   di,   si

mov   al,   '\'
call  StrChr
jnc   @@invalid

mov   al,   '*'
call  StrChr
jnc   @@invalid

mov   al,   '?'
call  StrChr
jnc   @@invalid

mov   al,   ','
call  StrChr
jnc   @@invalid

@@compareloop:
mov   al,   [si]
cmp   al,   0h                      ; done?
je    @@valid                       ; yes, valid path
cmp   al,   32                      ; low control characters?
jb    @@invalid                     ; yep, invalid
cmp   al,   127                     ; 127 or high ascii??
jae   @@invalid                     ; yep
inc   si
jmp   @@compareloop

@@valid:
@@return:
mov   si,   di
pop   di
pop   ax
ret
@@invalid:
stc
jmp   @@return


; ValidFileName - returns whether the given filename is a valid name
; INPUT:
; DS:SI - filename
; OUTPUT:
; Carry set on invalid
;
ValidFileName:
push  es
push  di
push  ax
call  StrLen
cmp   ax,   24
ja    @@invalid
call  ValidPathName
jc    @@invalid
mov   al,   '/'
call  StrChr
jnc   @@invalid
push  cs
pop   es
mov   di,   offset   szDirCurrent
call  StrCmp
jnc   @@invalid
mov   di,   offset   szDirPrevious
call  StrCmp
jnc   @@invalid
clc
@@return:
pop   ax
pop   di
pop   es
ret
@@invalid:
stc
jmp   @@return


; GetPathToken - retrieves the next token from a given pathname
; INPUT:
; DS:SI - pathname
; ES:DI - buffer to place token, 25 chars min
; OUTPUT:
; DS:SI - pathname, minus first token
; ES:DI - first token of pathname
;
GetPathToken:
pushf
push  ax

mov   al,   [si]
cmp   al,   '/'
jne   @@dontinc
inc   si
@@dontinc:

cld

@@tokenloop:
mov   al,   [si]
test  al,   al
jz    @@endloop
stosb
inc   si
mov   al,   [si]
cmp   al,   '/'
jne   @@tokenloop
@@endloop:
mov   [byte es:di],  0h
pop   ax
popf
ret


; -------------------- DATA SECTION -------------------
szDirRoot        db    "/",0
szDirCurrent     db    ".",0
szDirPrevious    db    "..",0

