VALIDMEMCODE   EQU   5BE669C0h

ALIGN 4
MemStartSegment   dw    0


; InitMemAlloc - sets up memory allocation to start from a given base segment
; INPUT:
; ES - segment to begin memory allocation at
; OUTPUT:
; none
;
InitMemAlloc:
push  di
push  ax
mov   ax,   es
mov   [MemStartSegment],   ax
sub   di,   di
mov   [(MemBlockHead PTR es:di).IDCode], VALIDMEMCODE
mov   [(MemBlockHead PTR es:di).Length], 9800h
sub   [(MemBlockHead PTR es:di).Length], ax
mov   [(MemBlockHead PTR es:di).Used],   0h
pop   ax
pop   di
ret


; AllocMem - dynamically allocate a certain number of bytes
; INPUT:
; EAX - number of bytes requested
; OUTPUT:
; ES:BX - seg:offset of block (both zero if alloc failed)
; Carry set on error
;
PROC  AllocMem    NEAR
LOCAL lowlen:WORD, lowseg:WORD =stack_size
STACKFRAME
pushad
push  ds
call  BytesToMemBlocks  ; cx = number of blocks requested

sub   si,   si          ; si = dx = 0
sub   dx,   dx

; for1(lowlen=0xFFFF,curseg=FirstSeg;...;...)
mov   [lowlen],   0FFFFh
mov   ax,   [MemStartSegment]
mov   ds,   ax

@@loopstart:
mov   ax,   ds    ; for1(...;curseg;...) {
test  ax,   ax
jz    @@loopend

cmp   [(MemBlockHead PTR si).Used], 0        ; if (curseg.Used) continue;
jne   @@loopit

mov   ax,   [(MemBlockHead PTR si).Length]   ; if (length <= curseg.Length
cmp   cx,   ax
ja    @@loopit
cmp   ax,   [lowlen]                         ; && curseg.Length < lowlen)
jae   @@loopit
                                             ; {
mov   [lowlen],   ax                         ; lowlen = curseg.Length;
mov   dx,   ds                               ; lowseg = curseg
                                             ; }

@@loopit:            ; for1(...;...;curseg = NextSeg(curseg))
call  NextMemBlock
jmp   @@loopstart
                     ; }

@@loopend:
test  dx,   dx       ; if (!lowseg) return NULL;
je    @@error

mov   ds,   dx       ; Split(lowseg, newlen);
mov   [(MemBlockHead PTR si).Used], 1h
mov   al,   [CurrentProcess]
mov   [(MemBlockHead PTR si).ProcessID], al

mov   ax,   [lowlen] ; newlen = lowlen - length;
cmp   ax,   cx       ; if (newlen)
jz    @@return
                     ; {
call  SplitMemBlock
                     ; }             0

@@return:            ; return lowseg:8;
mov   [lowseg],   dx
pop   ds
popad
push  [lowseg]
pop   es
mov   bx,   8
ENDSTACKFRAME
clc
ret

@@error:             ; return NULL;
pop   ds
popad
sub   bx,   bx
mov   es,   bx
ENDSTACKFRAME
stc
ret
ENDP  AllocMem


; ReallocMem - allocate, resize, or free a block of memory
; INPUT:
; EAX - number of bytes requested (frees the block if eax == 0)
; ES:BX - seg:offset of block to resize or NULL to allocate it
; OUTPUT:
; ES:BX - seg:offset of block (zero on error)
; Carry set on error
;
ReallocMem:
push  ds
pushad

test  bx,   bx    ; if (!ptr)
jnz   @@haveptr
mov   bx,   es
test  bx,   bx
jnz   @@haveptr
                  ; {
test  eax,  eax   ; if (length) return AllocMem(length)
jz    @@error     ; else return NULL;
popad
pop   ds
call  AllocMem
ret               ; }

@@haveptr:
push  es
pop   ds
mov   dx,   bx
call  ValidMemBlock  ; if (Invalid(ptr)) return NULL;
jc    @@error
test  eax,  eax   ; if (!length) return Free(ptr);
jnz   @@havelen
popad
pop   ds
call  FreeMem
ret

@@havelen:
call  BytesToMemBlocks  ; length = Convert(length); // cx = blocks requested

sub   si,   si
mov   dx,   [(MemBlockHead PTR si).Length]
cmp   cx,   dx    ; if (length < ptr.Length)
jae   @@grow
call  SplitMemBlock  ; return Split(ptr, length);
popad
pop   ds
ret
@@grow:
je    @@return       ; if (length == ptr.length) return ptr; // already good
push  ds             ; seg = Next(ptr)
call  NextMemBlock
mov   ax,   ds
mov   es,   ax
pop   ds

test  ax,   ax       ; if (!seg || seg.Used) goto AllocMove
jz    @@allocmove
cmp   [(MemBlockHead PTR es:si).Used], 0h
jne   @@allocmove

mov   ax, [(MemBlockHead PTR es:si).Length]
add   dx,   ax    ; dx = ptr.Length + seg.Length

cmp   cx,   dx    ; if (length <= total)
ja    @@allocmove ; {
je    @@return    ;    if (length == total) return ptr;
mov   ax,   cx
sub   cx,   [(MemBlockHead PTR si).Length]  ; newlen = length - ptr.Length;
mov   [(MemBlockHead PTR si).Length], ax    ; ptr.Length = length
push  es               ; Split(seg, newlen);
pop   ds
call  SplitMemBlock
@@return:
popad                  ; return ptr;
pop   ds
clc
ret               ; }
                  ; else
@@allocmove:      ; {
popad             ; restore original regs
pushad
mov   si,   bx          ; ds:si = ptr
call  BytesToMemBlocks  ; try and allocate the memory we need
call  AllocMem          ; temp = AllocMem(length);
mov   ax,   es          ; if (!temp) return NULL;
or    ax,   bx
test  ax,   ax
jz    @@error
mov   di,   bx          ; es:di = temp
sub   bx,   bx          ; bx = 0
sub   ecx,  ecx         ; ecx = BlocksToBytes(ptr.Length);
mov   cx,   [(MemBlockHead PTR bx).Length]
dec   cx
shl   ecx,  4
add   ecx,  8
call  CopyMemory        ; memcpy(temp, ptr, BlocksToBytes(ptr.Length));
mov   ax,   es          ; ax:di = temp
push  ds
pop   es
mov   bx,   si          ; es:bx = ptr
mov   ds,   di          ; ax:ds = temp
call  FreeMem           ; FreeMem(ptr);
mov   es,   ax          ; es:ds = temp
popad
mov   bx,   ds          ; es:bx = temp
pop   ds
clc
ret                     ; return temp;
@@error:
popad
pop   ds
sub   bx,   bx
mov   es,   bx
stc
ret                     ; return NULL;


; FreeMem - free a dynamically allocated block
; INPUT:
; ES:BX - seg:offset of block
; OUTPUT:
; Carry set on error
;
FreeMem:
push  ds
push  es
pushad
push  es
pop   ds
mov   dx,   bx          ; ds:dx = block
call  ValidMemBlock     ; if (Invalid(ptr)) return;
jc    @@error

sub   si,   si
mov   [(MemBlockHead PTR si).Used], 0h ; ptr.Used = FALSE;

mov   ax,   [MemStartSegment]  ; seg = FirstSeg;
mov   ds,   ax

@@loopstart:
mov   ax,   ds    ; while(seg)
test  ax,   ax    ; {
jz    @@loopend

cmp   [(MemBlockHead PTR si).Used], 0h    ; if (seg.Used)
je    @@firstblank                        ; {
call  NextMemBlock                        ;    seg = NextSeg(seg);
jmp   @@loopstart                         ;    restart;
                                          ; }
@@firstblank:
push  ds                                  ; next = NextSeg(seg);
call  NextMemBlock
push  ds
pop   es
pop   ds
mov   ax,   es                            ; if (!next) break;
test  ax,   ax
jz    @@loopend
cmp   [(MemBlockHead PTR es:si).Used], 0h ; if (next.Used)
je    @@secondblank                       ; {
push  es                                  ;    seg = next
pop   ds                                  ;    restart;
jmp   @@loopstart                         ; }
@@secondblank:
mov   ax,   [(MemBlockHead PTR es:si).Length] ; seg.Length += next.Length;
add   [(MemBlockHead PTR si).Length],  ax
jmp   @@loopstart
@@loopend:
@@return:
popad
pop   es
pop   ds
clc
ret
@@error:
popad
pop   es
pop   ds
stc
ret


; CopyMemory - copies a block of memory from one place in ram to another
; INPUT:
; DS:SI - source pointer
; ES:DI - destination pointer
; ECX   - number of bytes to copy (0 to 65536)
; OUTPUT:
; none
;
CopyMemory:
push  eax
push  ebx
push  ecx
push  di
push  si

cmp   ecx,  0
jle   @@end
mov   ebx,  ecx
and   bl,   3
cmp   ecx,  4
jl    @@second

shr   ecx,  2

@@loopstart:
mov   eax,  [si]
add   si,   4
mov   [es:di], eax
add   di,   4
dec   ecx
jne   @@loopstart

@@second:
mov   cl,   bl
rep   movsb

@@end:
pop   si
pop   di
pop   ecx
pop   ebx
pop   eax
ret


; MemCmp - compares two blocks of memory
; INPUT:
; DS:SI - block1
; ES:DI - block2
; CX    - max bytes to check
; OUTPUT:
; Carry set if they differ
; AL    - 0 if equal,  negative if block1<block2,  positive if block1<block2
;
MemCmp:
push  si
push  di
push  cx

test  cx,  cx
jz    @@equal

dec   di

@@loopstart:
mov   al,   [si]
inc   si
inc   di
cmp   al,   [es:di]
ja    @@above
jb    @@below
dec   cx
jnz   @@loopstart

@@equal:
clc
mov   al,   0
jmp   @@return
@@above:
stc
mov   al,   1
jmp   @@return
@@below:
stc
mov   al,   -1
@@return:
pop   cx
pop   di
pop   si
ret


; ----------------------------------------------------------------------------
; ValidMemBlock - sets carry if the given block is not a valid memory block
;                 not 100% accurate.. but works well enough
; INPUT:
; DS:DX - memory block address to be checked
; OUTPUT:
; Carry flag set if the block is determined to be invalid
ValidMemBlock:
push  si
push  ax
mov   ax,   ds
cmp   dx,   8
jne   @@bad
cmp   ax,   [MemStartSegment]
jb    @@bad
cmp   ax,   9800h     ; >= this is invalid
jae   @@bad
sub   si,   si       ; si = 0
cmp   [(MemBlockHead PTR si).IDCode], VALIDMEMCODE
jne   @@bad
@@good:
clc
pop   ax
pop   si
ret
@@bad:
stc
pop   ax
pop   si
ret


; GetFreeMem - returns the amount of free memory in bytes
; INPUT:
; none
; OUTPUT:
; EAX - number of bytes of free memory
;
GetFreeMem:
push  ds
push  si
push  ebx

mov   bx,   [MemStartSegment]
mov   ds,   bx
sub   eax,  eax
sub   ebx,  ebx
sub   si,   si

@@loopstart:
mov   bx,   ds
test  bx,   bx
je    @@loopend

mov   bx,   [(MemBlockHead PTR si).Length]
sub   bx,   1     ; eax += (ebx - 1)*16
shl   ebx,  4
add   eax,  8
add   eax,  ebx

call  NextMemBlock
jmp   @@loopstart

@@loopend:
pop   ebx
pop   si
pop   ds
ret


; NextMemBlock - advances DS to the next memory block
; INPUT:
; DS - current memory block
; OUTPUT:
; DS - next memory block, or 0 if the previous was at the end (or an error)
;
NextMemBlock:
push  cx
push  dx
push  si
mov   dx,   8
sub   si,   si
call  ValidMemBlock
jc    @@error

mov   cx,   ds
add   cx,   [(MemBlockHead PTR si).Length]
mov   ds,   cx

call  ValidMemBlock
jc    @@error
pop   si
pop   dx
pop   cx
ret
@@error:
sub   dx,   dx
mov   ds,   dx
pop   si
pop   dx
pop   cx
ret


; BytesToMemBlocks - converts a length into a number of memory blocks
; blocks = (length - 8) / 16 + 1 (+1 more if [length-8]/16 > 0)
; INPUT:
; EAX - length, in bytes (signed dword)
; OUTPUT:
; CX - length, in blocks
;
BytesToMemBlocks:
push  eax
sub   cx,   cx
inc   cx          ; cx = 1
sub   eax,  8
jle   @@end       ; end with blocks = 1 if length <= 8

test  eax,  0Fh   ; check if (length - 8) is not a multiple of 16
jz    @@skipadd
inc   cx
@@skipadd:

shr   eax,  4     ; divide length by 16
add   cx,   ax    ; add blocks

@@end:
pop   eax
ret


; SplitMemBlock - splits a memory block into two blocks with the first being
;               - a given length
; INPUT:
; DS - block to split
; CX - number of blocks in the first partition (MUST be <= ds.Length)
; OUTPUT:
; carry clear
;
SplitMemBlock:
push  ds
push  si
push  ax
push  cx
push  dx

sub   si,   si                               ; adjust Length of first block
mov   ax,   [(MemBlockHead PTR si).Length]
cmp   ax,   cx
je    @@nowork
mov   [(MemBlockHead PTR si).Length],  cx

xchg  cx,   ax    ; cx = total block length, ax = first block length
sub   cx,   ax    ; cx = length of 2nd block
mov   dx,   ds
add   ax,   dx
mov   ds,   ax    ; ds = segment of 2nd block
mov   [(MemBlockHead PTR si).IDCode], VALIDMEMCODE
mov   [(MemBlockHead PTR si).Length], cx
mov   [(MemBlockHead PTR si).Used],   0
push  ds
call  NextMemBlock
cmp   [(MemBlockHead PTR si).Used],   0
jne   @@dontcombine
add   cx,   [(MemBlockHead PTR si).Length]
@@dontcombine:
pop   ds
mov   [(MemBlockHead PTR si).Length], cx

@@nowork:
pop   dx
pop   cx          ; restore changed values
pop   ax
pop   si
pop   ds
clc
ret

