; Vectors are stored as offset, then segment in memory
; SetInterrupt - Replaces a vector in the interrupt table
; INPUT:
; al - interrupt to replace
; DS:DX - seg:offset of new handler
; OUTPUT:
; 
SetInterrupt:
pushf             ; save the flags
cli               ; dont want any interrupts happening
push bx           ; we'll change this
push es           ; and this

sub   bx,   bx    ; bx = 0
mov   es,   bx    ; es = 0
mov   bl,   al    ; bx = vector
shl   bx,   2     ; bx = byte index

mov   [es:bx],   dx ; save offset
mov   [es:bx+2], ds ; save segment

pop   es          ; restore what we changed
pop   bx
popf              ; restore flags
ret               ; return
; SetInterrupt ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; GetInterrupt - gets the address of an interrupt vector
; INPUT:
; al - interrupt to get
; OUTPUT:
; ES:BX - seg:offset of handler
;
GetInterrupt:
push ds           ; changing this

sub   bx,   bx    ; bx = 0
mov   ds,   bx    ; ds = 0
mov   bl,   al    ; bx = vector
shl   bx,   2     ; bx = byte index

mov   es, [ds:bx+2] ; fetch segment
mov   bx, [ds:bx]   ; fetch offset

pop   ds          ; restore what we changed
ret               ; return
; GetInterrupt ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
