LOCALS @@
SMART
IDEAL

p386

INCLUDE "OS.INC"        ; for everything
INCLUDE "Macros.INC"    ; macros
INCLUDE "Memory.INC"    ; include file for Memory.asm
INCLUDE "FilesLow.INC"  ; include file for FilesLow.asm
INCLUDE "FilesHi.INC"   ; include file for FilesHi.asm

segment code use16
assume CS:code
org 0h

OSLoad:              ; entry point of operating system
jmp   OSMain

OSIntBase:           ; base of interrupt handler

OSIntEnd:
iret

                       ; load other modules here
INCLUDE "CType.ASM"    ; character routines
INCLUDE "String.ASM"   ; string routines
INCLUDE "Misc.ASM"     ; miscellaneous routines
INCLUDE "Screen.ASM"   ; screen output routines
INCLUDE "Keyboard.ASM" ; keyboard input routines
INCLUDE "Memory.ASM"   ; dynamic allocation routines
INCLUDE "Process.ASM"  ; program spawning/closing/etc routines
INCLUDE "RawDisk.ASM"  ; raw disk access routines
INCLUDE "FilesLow.ASM" ; lower level file access (FAT, file blocks, etc)
INCLUDE "FilesHi.ASM"  ; higher level file access


OSMain:
cli                        ; no interrupts during stack setup!
                           ; set up stack.. 32k block at top of memory
;mov   ax,   9800h          ; ax = 9800h
;mov   ss,   ax             ; ss = 9800h
;mov   sp,   8000h          ; sp = 8000h (dword aligned)
;sub   bp,   bp

;sti

cld                  ; go forward
push  cs
pop   ds             ; ds = cs

mov   al,   ' '      ; spaces
mov   bl,   7h       ; grey on black
call  ClearScreen

mov   bl,   2Fh      ; white on green
mov   si, offset @@Title  ; title message
call  WriteStrAttr   ; write it

mov   si, offset @@Blank  ; newline
call  WriteString    ; write it

mov   dx,   offset EndOfKernel
shr   dx,   4
inc   dx
push  cs
pop   bx
add   dx,   bx
mov   es,   dx
;call  InitMemAlloc   ; initialize dynamic memory allocation

push  cs
pop   es
mov   di,   offset @@Str1
mov   si,   offset @@Str2
call  StrCpy
mov   si,   offset @@Str3
call  StrCat
mov   si,   offset @@Str4
call  StrCmp
call  StrUpper
call  StrCmp
call  StrCmpI
call  StrLower
mov   al,   'e'
call  StrChr

mov   al,   0
call  IsSpace
call  IsAlpha
call  IsAlnum
call  IsDigit
call  IsCntrl
call  IsLower
call  IsUpper
call  IsPunct


mov   si, offset @@AnyKey
call  WriteString
call  GetKeypress    ; wait for a key

mov   ax, 4c00h
int   21h

@@Title   db 33 dup(32), 'AdamOS Startup', 33 dup(32), 0
@@Blank   db 13, 10, 0
@@AnyKey  db 'Press any key to quit...', 0

@@Str1    db 128 dup('A'),0
@@Str2    db 'Hello, ',0
@@Str3    db 'World!',0
@@Str4    db 'Hello, World!',0

EndOfKernel:
ends
end OSLoad

