#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

int WriteSector(int abssector, char far *buf)
{
   int retu=1;

   asm {
   push es
   les bx, buf
   mov al, 0
   mov cx, 1
   mov dx, abssector
   int 26h
   pop cx
   jc End
   mov retu, 0
   }
   End:
   return retu;
}

int main(int argc, char *argv[])
{
   FILE *file;
   unsigned long filelen, blocks, sect;
   char buf[512], far *bufp = buf;

   if (argc != 3)
   {
      puts("USAGE: RawWrite sector filename");
      return -1;
   }

   sect = atol(argv[1]);

   file = fopen(argv[2], "rb");
   if (!file)
   {
      puts("Error opening file.");
      return -1;
   }

   fseek(file, 0, SEEK_END);
   filelen = ftell(file);
   fseek(file, 0, SEEK_SET);

   blocks = filelen / 512 + (filelen % 512 ? 1 : 0);
   while(blocks)
   {
      fread(buf, 1, 512, file);
      if (WriteSector(sect, bufp)) printf("Error writing sector %d.\n", sect);
      sect++;
      blocks--;
   }

   fclose(file);
   return 0;
}
