; StrLen   - returns length of ASCIIZ string
; macro - STRLEN str
; INPUT:
; DS:SI - address of string
; OUTPUT:
; AX    - length of string
;
StrLen:
pushf
push  bx
push  cx
push  di
push  es
cld               ; going forward
sub   al,   al    ; al = 0 (search for this char)
sub   cx,   cx    ; cx = 0
sub   cx,   si    ; cx = length from si to end of segment (max to search)
push  ds
pop   es          ; es = ds
mov   di,   si    ; es:di -> string
repnz scasb       ; search for null char
sub   di,   si
dec   di          ; di = length of string
mov   ax,   di    ; ax = length of string
pop   es
pop   di
pop   cx
pop   bx
popf
ret

; StrLenW      - returns length of wide-char (2 byte) ASCIIZ string
; macro - STRLENW str
; INPUT:
; DS:SI - address of string
; OUTPUT:
; AX    - length of string in number of chars
;
StrLenW:
pushf
push  bx
push  cx
push  di
push  es
cld               ; going forward
sub   ax,   ax    ; al = 0 (search for this char)
sub   cx,   cx    ; cx = 0
sub   cx,   si    ; cx = length from si to end of segment (max to search)
shr   cx,   1     ; 2-byte chars, so cut in half
push  ds
pop   es          ; es = ds
mov   di,   si    ; es:di -> string
repnz scasw       ; search for null char
sub   di,   si
sub   di,   2     ; di = length of string * 2
mov   ax,   di    ; ax = length of string
shr   ax,   1     ; divide by two
pop   es
pop   di
pop   cx
pop   bx
popf
ret


; StrCpy - copies one string into another
; INPUT:
; DS:SI  - source string
; ES:DI  - dest string
; OUTPUT:
; dest string = source string
;
StrCpy:
push  ax
push  ecx

call  StrLen               ; memcpy(dest, src, strlen(src)+1);
sub   ecx,  ecx
inc   ax
mov   cx,   ax

call  CopyMemory

pop   ecx
pop   ax
ret


; StrCat - appends one string onto another
; INPUT:
; DS:SI  - source string
; ES:DI  - dest string
; OUTPUT:
; dest string = source string + dest string
;
StrCat:
push  di
push  ax
push  ecx

xchg  si,   di       ; dest += strlen(dest);
push  ds
push  es
pop   ds
call  StrLen
pop   ds
xchg  si,   di
add   di,   ax

call  StrLen         ; memcpy(dest, src, strlen(src)+1);

sub   ecx,  ecx
inc   ax
mov   cx,   ax

call  CopyMemory

pop   ecx
pop   ax
pop   di
ret


; StrCmp - compares two strings
; INPUT:
; DS:SI  - string 1
; ES:DI  - string 2
; OUTPUT:
; Carry set if they are unequal
; AL     - 0 if strings are equal/negative if str1<str2, positive if str1>str2
; 
StrCmp:
push  cx
push  ax

call  StrLen         ; memcmp(dest, src, MIN(strlen(src),strlen(dest))+1);
mov   cx,   ax
push  ds
push  es
pop   ds
xchg  si,   di
call  StrLen
xchg  si,   di
pop   ds

cmp   cx,   ax
jbe   @@skip
mov   cx,   ax

@@skip:
inc   cx
pop   ax

call  MemCmp
pop   cx
ret


; StrCmpI - compares two strings, case insensitive
; INPUT:
; DS:SI  - string 1
; ES:DI  - string 2
; OUTPUT:
; Carry set if they are unequal
; AL     - 0 if strings are equal, negative if str1<str2, positive if str1>str2
;
StrCmpI:
push  si
push  di
push  cx
push  ax

call  StrLen               ; memcmp(dest, src, MIN(strlen(src),strlen(dest))+1);
mov   cx,   ax
push  ds
push  es
pop   ds
xchg  si,   di
call  StrLen
xchg  si,   di
pop   ds

cmp   cx,   ax
jbe   @@skip
mov   cx,   ax

@@skip:
inc   cx

@@loopstart:
mov   al,   [si]
inc   si
call  ToLower
mov   ah,   al
mov   al,   [es:di]
inc   di
call  ToLower
cmp   ah,   al
ja    @@above
jb    @@below
dec   cx
jnz   @@loopstart

@@equal:
clc
mov   al,   0
jmp   @@return
@@above:
stc
mov   al,   1
jmp   @@return
@@below:
stc
mov   al,   -1
@@return:
pop   cx       ; ax
mov   ah,   ch ; restore ah
pop   cx
pop   di
pop   si
ret


; StrChr - returns first occurence in a string of a given character
; INPUT:
; AL     - character to look for
; DS:SI  - string to search
; OUTPUT:
; Carry set if not found
; DS:SI  - pointer to character..
;
StrChr:
pushf
push  es
push  di
push  cx
push  ax

call  StrLen       ; cx = strlen
mov   cx,   ax
pop   ax
test  cx,   cx
jz    @@notfound

push  si

cld               ; scan forward
push  ds          ; es:di --> string
pop   es
mov   di,   si
pop   si

repnz scasb       ; search for char
test  cx,   cx    ; found?
jz    @@notfound

mov   si,   di
dec   si
clc
jmp   @@return

@@notfound:
stc

@@return:
pop   cx
pop   di
pop   es
popf
ret


; StrUpper - uppercases a string
; INPUT:
; DS:SI  - string to uppercase
; OUTPUT:
; STRING IS IN UPPERCASE
;
StrUpper:
push  si
push  ax
push  cx

call  StrLen
test  ax,   ax
jz    @@done

mov   cx,   ax

@@loopstart:
mov   al,   [si]
call  ToUpper
mov   [si], al
inc   si
dec   cx
jne   @@loopstart

@@done:
pop   cx
pop   ax
pop   si
ret


; StrLower - lowercases a string
; INPUT:
; DS:SI  - string to lowercase
; OUTPUT:
; string is in lowercase
;
StrLower:
push  si
push  ax
push  cx

call  StrLen
test  ax,   ax
jz    @@done

mov   cx,   ax

@@loopstart:
mov   al,   [si]
call  ToLower
mov   [si], al
inc   si
dec   cx
jne   @@loopstart

@@done:
pop   cx
pop   ax
pop   si
ret

