; IsSpace - returns true if character is whitespace (9h - 0Dh, 20h)
; INPUT:
; AL - character
; OUTPUT:
; Carry set if character is whitespace
;
IsSpace:
cmp   al,   20h
je    @@match
cmp   al,   09h
jb    @@notmatch
cmp   al,   0Dh
ja    @@notmatch
@@match:
stc
ret
@@notmatch:
clc
ret


; IsAlnum - returns true if character is a letter or number
; INPUT:
; AL - character
; OUTPUT:
; Carry set if character is a letter or number
;
IsAlnum:
call  IsAlpha
jc    @@match
call  IsDigit
ret
@@match:
stc
ret


; IsAlpha - returns true if character is a letter ('A' - 'Z' or 'a' to 'z')
; INPUT:
; AL - character
; OUTPUT:
; Carry set if character is a number
;
IsAlpha:
cmp   al,   'A'
jb    @@notmatch
cmp   al,   'z'
ja    @@notmatch
cmp   al,   'Z'
jbe   @@match
cmp   al,   'a'
jb    @@notmatch
@@match:
stc
ret
@@notmatch:
clc
ret


; IsCntrl - returns true if characters is a control character (0h - 1Fh, 7Fh)
; INPUT:
; AL - character
; OUTPUT:
; Carry set if character is a control character
;
IsCntrl:
cmp   al,   7Fh
je    @@match
cmp   al,   1Fh
ja    @@notmatch
@@match:
stc
ret
@@notmatch:
clc
ret


; IsDigit - returns true if character is a number
; INPUT:
; AL - character
; OUTPUT:
; Carry set if character is a number
;
IsDigit:
cmp   al,   '0'
jb    @@notmatch
cmp   al,   '9'
ja    @@notmatch
stc
ret
@@notmatch:
clc
ret


; IsLower - returns true if character is a lowercase letter
; INPUT:
; AL - character
; OUTPUT:
; Carry set if character is a lowercase letter
;
IsLower:
cmp   al,   'a'
jb    @@notmatch
cmp   al,   'z'
ja    @@notmatch
stc
ret
@@notmatch:
clc
ret


; IsUpper - returns true if character is an uppercase letter
; INPUT:
; AL - character
; OUTPUT:
; Carry set if character is an uppercase letter
;
IsUpper:
cmp   al,   'A'
jb    @@notmatch
cmp   al,   'Z'
ja    @@notmatch
stc
ret
@@notmatch:
clc
ret


; IsPunct - returns true if character is punctuation (20h-7Eh !IsSpace !Alnum)
; INPUT:
; AL - character
; OUTPUT:
; Carry set if character is a punctuation character
IsPunct:
cmp   al,   20h
jb    @@notmatch
cmp   al,   7Eh
ja    @@notmatch
call  IsSpace
jc    @@notmatch
call  IsAlnum
jc    @@notmatch
stc
ret
@@notmatch:
clc
ret


; ToUpper - converts a character to uppercase
; INPUT:
; AL - character
; OUTPUT:
; AL - character in uppercase
;
ToUpper:
cmp   al,   'a'
jb    @@done
cmp   al,   'z'
ja    @@done
sub   al,   32
@@done:
ret


; ToLower - converts a character to lowercase
; INPUT:
; AL - character
; OUTPUT:
; AL - character in lowercase
;
ToLower:
cmp   al,   'A'
jb    @@done
cmp   al,   'Z'
ja    @@done
add   al,   32
@@done:
ret

