;GetKeypress - waits for and gets a single keypress
;INPUT:
;none
;OUTPUT:
;AH - bios scan code
;AL - ascii character
;
GetKeypress:
mov   ah,   10h      ; get enhanced keystroke
int   16h
ret

; CheckForKey - checks to see if a key is ready to be read, doesnt remove it
;               from the keyboard buffer
; INPUT:
; none
; OUTPUT:
; ZF - set for no key, clear for key
; AH - bios scan code
; AL - ascii code
CheckForKey:
mov   ah,   11h      ; check for enhanced keystroke
int   16h
ret

; ReadString  - reads a string from the keyboard, skips extended characters
; INPUT:
; DS:SI - input buffer
; CX    - buffer length (including null terminator)
; OUTPUT:
; CX    - chars read
;
ReadString:
pushf
pusha
test  cx,   cx    ; cx = 0?
jz    @@end       ; quit

sub   bx,   bx    ; bx = offset into buffer (0)

@@readchar:
mov   dx,   cx    ; dx = max length
sub   dx,   bx    ; dx = space left
jz    @@end       ; really only needed the first time, but oh well

@@doread:
sub   ah,   ah    ; ah = 00h, get standard keystroke function
int   16h         ; get key
cmp   al,   08h   ; backspace?
jne   @@checkCR   ; if not, check CR
cmp   bx,   0     ; if it's already empty, dont backspace
je    @@readchar  ; it's empty already, get next char
dec   bx
pusha             ; save regs that we'll be changing
mov   ah,   3h    ; 2h = get cursor pos
int   10h         ; get it
test  dl,   dl    ; are we at the beginning of the line?
jne   @@doBS      ; nope, do the backspace
dec   dh          ; move up a line
mov   ah,   0Fh   ; get video mode for char columns
int   10h         ; get # of char columns into ah
mov   dl,   ah
dec   dl
mov   ah,   2h    ; set cursor pos
int   10h         ; set it
mov   al,   ' '   ;
call  WriteChar   ; erase char there
int   10h         ; reset cursor
popa
jmp   @@readchar  ; read next
@@doBS:
popa              ; restore regs
call  WriteChar   ; echo the backspace
mov   al,   ' '   ; al = space
call  WriteChar   ; erase the letter we backspaced
mov   al,   08h   ; al = backspace
call  WriteChar   ; backspace over the space
jmp   @@readchar  ; and get the next char
@@checkCR:
cmp   al,   0Dh   ; carriage return?
je    @@finish    ; we're done, so terminate the string
cmp   dx,   1     ; only one byte left? (can only be CR then)
jnz   @@other
mov   al,   7h    ; bell char
call  WriteChar   ; sound the alarm!
jmp   @@doread    ; read next char
@@other:          ; not CR and enough space to store it
cmp   al,   ' '   ; any other low ascii chars arent accepted
jl    @@doread    ; ignore it and get next
call  WriteChar   ; echo it
mov   [ds:si+bx], al ; store the letter
inc   bx          ; increment our index
jmp   @@readchar  ; and get the next char
@@finish:         ; leaving..
call  WriteChar   ; echo the CR
mov   al,   0Ah   ; line feed
call  WriteChar   ; advance to the next line
mov   [byte ds:si+bx], 0h ; NULL terminate
mov   cx,   bx    ; cx = length of string read
@@end:            ; restore and leave
popa
popf
ret

