; WriteChar - writes a single character to the display, control characters
;           - can be used to control output
; INPUT:
; al - character to write
; OUTPUT:
; none
WriteChar:
push  cx
mov   cx,   1
call  WriteCharM
pop   cx
ret


; WriteCharM - writes a character to the display cx times, control characters
;            - can be used to control output
; INPUT:
; al - character to write
; cx - times to write it
; OUTPUT:
; none
WriteCharM:
pusha
push  ax
mov   ah,   0Fh ; get current display page
int   10h
mov   bl,   07h ; grey in graphics mode

pop   ax
mov   ah,   0Eh ; teletype output
@@wcloop:
int   10h       ; write it
dec   cx
jne   @@wcloop

popa
ret


; ClearScreen  - Clears the screen
; INPUT:
; al - character
; bl - attribute
; OUTPUT:
; none
;
ClearScreen:
pusha          ; save registers
push  ax       ; save character

mov   ah,   0Fh ; get current display page
int   10h

mov   ah,   2h ; function 2h of int 10h, set cursor pos
sub   dx,   dx ; dx = 0 (position 0,0)
int   10h

mov   cx,   80*25 ; number of characters on the screen
pop   ax          ; restore character
mov   ah,   09h   ; funct 9h of int 10h write char+attr, using 20h (space)
int   10h         ; do the write!

mov   ah,   2h ; function 2h of int 10h, set cursor pos
int   10h      ; set cursor to 0, 0 again
popa           ; restore registers
ret


; WriteString  - writes the ASCIIZ string at the current cursor pos.
; INPUT:
; DS:SI - address of string
; OUTPUT:
; none
;
WriteString:
pushf
pusha

mov   ah,   0Fh ; get current display page
int   10h
mov   bl,   07h ; grey in graphics mode

mov   ah,   0Eh   ; teletype output function
@@next:
mov   al,   [si]
cmp   al,   0
jz    short @@end
int   10h
inc   si
jmp   short @@next
@@end:
popa
popf
ret


; WriteStrAttr - writes string at cursor pos. with certain attribute
; INPUT:
; DS:SI - address of string
; BL    - attribute
; OUTPUT:
; none
;
WriteStrAttr:
pushf
pusha
push  es
push  bx          ; save attribute

call  StrLen      ; ax = length of string
push  ax          ; save length

push  ds
pop   es          ; es = ds
mov   bp,   si    ; es:bp -> string

mov   ah,   0Fh   ; get current page into bh
int   10h

mov   ah,   03h   ; get cursor position into dl, dh
int   10h

pop   cx          ; restore length
pop   ax          ; restore attribute
mov   bl,   al    ; bl = attr
mov   al,   1     ; not alternating char/attr and update cursor
mov   ah,   13h   ; write string function of int 10h
int   10h         ; do the write

pop   es          ; restore es
popa              ; restore regs
popf              ; restore flags
ret


; WriteAttrStr - writes string with interleaved char/attr values
; INPUT:
; DS:SI - address of string
; OUTPUT:
; none
;
WriteAttrStr:
pushf
pusha
push  ax          ; save attribute

call  StrLenW     ; ax = length of string
push  ax          ; save length

push  ds
pop   es          ; es = ds
mov   bp,   si    ; es:bp -> string

mov   ah,   0Fh   ; get current page into bh
int   10h

mov   ah,   03h   ; get cursor position into dl, dh
int   10h

pop   cx          ; restore length
pop   ax          ; restore attribute
mov   bl,   al    ; bl = attribute
mov   al,   3     ; alternating char/attr and update cursor
mov   ah,   13h   ; write string function of int 10h
int   10h         ; do the write

popa              ; restore regs
popf              ; restore flags
ret

