# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
import sys;
import socket;
import re;
import md5;

def _unescape(str):
    return re.sub(r"\\(.)", r"\1", str)
def _splitline(line):
    m = re.match(r"^([^\s\"]+)\s+\"(.*)\"$", line)
    return (m.group(1), _unescape(m.group(2)))

class _rcode:
    def __init__(self, str=None):
        if str==None: (self.code,self.text) = (None,None)
        else: self.SetCode(str)
    def Code(self): return int(self.code)
    def Text(self): return self.text
    def Major(self): return int(self.code[:1])
    def SetCode(self, str):
        idx = str.find(' ')
        if idx==-1:
            self.code = str
            self.text = ""
        else:
            self.code = str[:idx]
            self.text = str[idx+1:]
    def RaiseOnError(self):
        code = self.Code()
        if code==4 or code==5:
            print "Unexpected result: %s %s" % (self.code,self.text)
            raise sys.Exception
    def Expect(self, code):
        if code!=self.Code():
            print "Expected code %d but got %s" % (code,self.code)
            raise sys.Exception

class DictProto:
    def __init__(self, server=None, port=2628):
        self.__socket = None
        self.__file   = None
        self.__db     = "*"
        self.__msgid  = "<>"
        if server != None: self.Connect(server, port)
    def __line(self): return self.__file.readline().rstrip()
    def __resp(self): return _rcode(self.__line())
    def __text(self):
        text = ""
        while True:
            line = self.__line()
            if line==".": break
            if text!="": text += "\n"
            text += line[:2]==".." and line[1:] or line
        return text
    def __send(self, s): self.__socket.send(s)

    def Connect(self, server, port=2628):
        self.__socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        self.__socket.connect((server,port))
        self.__file = self.__socket.makefile("r+", 1)
        resp = self.__resp()
        resp.Expect(220)
        m = re.match(r"(<.*?>)$", resp.Text())
        if m != None: self.__msgid = m.group(1)
    def Quit(self):
        self.__send("QUIT\r\n")
        resp = self.__resp()
        self.__socket.close()
        (self.__socket,self.__file) = (None,None)
    def Auth(self, user, auth):
        hash = md5.new()
        hash.update(self.__msgid+auth)
        self.__send("AUTH %s %s\r\n" % (user,hash.hexdigest().lower()))
        resp = self.__resp()
        return resp.Code()==231 and True or False
    def Ident(self, str):
        self.__send("CLIENT %s\r\n" % str)
        self.__resp()
    def ListDBs(self):
        self.__send("SHOW DB\r\n")
        resp = self.__resp()
        resp.Expect(110)
        dbs  = []
        for line in self.__text().splitlines(): dbs.append(_splitline(line))
        self.__resp().Expect(250)
        return dbs
    def ListStrategies(self):
        self.__send("SHOW STRAT\r\n")
        resp = self.__resp()
        resp.Expect(111)
        strats = []
        for line in self.__text().splitlines():
            strats.append(_splitline(line))
        self.__resp().Expect(250)
        return strats
    def GetServerInfo(self):
        self.__send("SHOW SERVER\r\n")
        resp = self.__resp()
        if resp.Major()==5: return ""
        resp.Expect(114)
        text = self.__text()
        self.__resp().Expect(250)
        return text
    def GetDBInfo(self, db):
        self.__send("SHOW INFO %s\r\n" % db)
        self.__resp().Expect(110)
        text = self.__text()
        self.__resp().Expect(250)
        return text
    def MatchWord(self, word, db=None, strategy="exact"):
        self.__send("MATCH %s %s \"%s\"\r\n" %
                    (db==None and self.__db or db, strategy, word))
        resp = self.__resp()
        if resp.Code()==552: return []
        resp.RaiseOnError()
        resp.Expect(152)
        matches = []
        for line in self.__text().splitlines():
            matches.append(_splitline(line))
        self.__resp().Expect(250)
        return matches
    def DefineWord(self, word, db=None):
        self.__send("DEFINE %s \"%s\"\r\n" % (db==None and self.__db or db, word))
        resp = self.__resp()
        resp.RaiseOnError()
        resp.Expect(150)
        defs = []
        while True:
            resp = self.__resp()
            if resp.Code()==250: break
            m = re.match(r"^\"((?:[^\"]|\\.)*?)\"\s*"
                         r"([^\s\"]+)"
                         r"\s*\"((?:[^\"]|\\.)*?)\"$",
                         resp.Text())
            defs.append(((_unescape(m.group(1)), m.group(2),
                          _unescape(m.group(3))),
                         self.__text()))
        return defs

if __name__ == "__main__":
    d = DictProto("dict.org")
    print d.DefineWord("hello")
