#ifndef _DEFINES_H
#define _DEFINES_H

#ifdef byte // just to make sure
#undef byte
#endif
typedef unsigned char byte;
typedef unsigned short word;
typedef signed char offset;

#undef  LOBYTE
#undef  HIBYTE
#undef  RGB
#define LOBYTE(w) ((byte)(w))
#define HIBYTE(w) ((byte)((w)>>8))
#define SETLOBYTE(w,v) ((w)=((w)&0xFF00)|(v))
#define SETHIBYTE(w,v) ((w)=((w)&0xFF)|((v)<<8))

/*** PALETTE STUFF ***/
#define GETRED(e)     ((e)>>11)
#define GETGREEN(e)   (((e)>>5)&0x3F)
#define GETBLUE(e)    ((e)&0x1F)
// take word and byte, return word
#define SETRED(e,v)   ((e)=((e)&0x7FF)|((v)<<11))
#define SETGREEN(e,v) ((e)=((e)&0xF81F)|((v)<<5))
#define SETBLUE(e,v)  ((e)=((e)&0xFFE0)|(v))
// take 3 bytes, return word
#define RGB(r,g,b)    (((r)<<11)|((g)<<5)|(b))
/*** END PALETTE STUFF ***/

/*** TIMING STUFF ***/
// for a 4.7mhz machine running at 60fps with 224 scanlines
#define CYCLES_PER_SCANLINE 297
#define VBLANK_SCANS        40 // 0 disables vblank interrupt!
#define CYCLES_PER_VBLANK   (CYCLES_PER_SCANLINE*VBLANK_SCANS)
#define NUM_SCANS           224
/*** END TIMING STUFF ***/

#define BANKSIZE  12*1024

#define BASEMAX   0x2EFF
#define SPRTILE   0x2F00
#define BAKTILE   0x3F00
#define IMGDATA   0x4F00
#define SPRITES   0x6B00
#define INTTAB    0x6F00
#define BANK0     0x7000
#define BANKX     0xA000
#define BANKY     0xD000

#endif
