#ifndef _ECLAIR_H
#define _ECLAIR_H

#include <iostream.h>
#include "Defines.h"
#include "Z80.h"

enum BUTTON
{ BTN_UP=0, BTN_DOWN, BTN_LEFT, BTN_RIGHT, BTN_A, BTN_B, BTN_X, BTN_Y
};

enum SNDTYPE
{ SND_SQUARE, SND_SINE, SND_TRI, SND_NOISE
};
struct SndChannel
{
  word freq;
  byte vol;
  struct
  {
    unsigned type:2; // SNDTYPE
    unsigned PW  :6;
  } info;
};

enum PCMTYPE
{ PCM_NONE, PCM_NORMAL, PCM_REVERSE, PCM_PINGPONG   // loop types
};
struct PCMChannel
{
  word freq;
  word offset;
  word start, end; // exclusive!
  struct
  {
    unsigned type :2; // PCMTYPE (loop types)
  } info;
  unsigned long inc, off;
  bool forward;
};

typedef void (*DRAWFUNCT)(byte const *scan, word const palette[256],
                          int scanline); // scanline == 255 for vblank
typedef void (*SOUNDFUNCT)(SndChannel const chans[7],
                           PCMChannel &PCMchan);

class Eclair
{
  public:
    /*** PUBLIC FUNCTIONS ***/
    Eclair();
    ~Eclair();

    void Reset(); // doesnt do much if rom isnt loaded...
    int  LoadROM(istream &file); // calls Reset() too
    char const *RomName();  // returns the name of the ROM or NULL

    void SetDraw(DRAWFUNCT fxn);
    void SetSound(SOUNDFUNCT fxn);
    bool SoundDirty() // sound regs have changed
    { if (m_SoundDirty) return !(m_SoundDirty=false);
      else return false;
    }
    inline byte ReadMem(word Addr)
    {
      return m_pMem[Addr];
    }

    // calls draw each scanline and sound() once per frame
    int DoScan(); // returns nonzero if a frame is done

    /* controller stuff */
    void Press(int controller, BUTTON btn, int down);
    /* end controller stuff */

  /*** PROTECTED STUFF ***/
  protected:
    Z80  m_CPU;
    byte *m_pROM;
    byte *m_pMem;
    byte *m_pScans;
    word m_Palette[256];

    SndChannel m_SndChans[7];
    PCMChannel m_PCMChan;
    byte m_Control[2];

    union
    {
      byte values[4];
      struct
      {
        byte left,top,right,bottom;
      } c;
    } m_Viewport;

    byte m_HPanning, m_VPanning, m_TPitch;
    int  m_Scanline;
    byte m_PalEntry;
    byte m_XBank, m_YBank;
    byte m_VPBkgnd, m_NVPBkgnd;
    byte m_NumBanks;
    bool m_DoReset, m_SoundDirty;

    DRAWFUNCT  m_DrawFxn;
    SOUNDFUNCT m_SoundFxn;

    void ResetSystem(); // called after rom has been loaded to set up members
    inline void DrawSprite(byte *dest, int num, int x, int y, int scanline, byte info);
    void DoDraw(int scanline);

    friend void _OutZ80(Z80 *R, register word Port,register byte Value);
    friend byte _InZ80(Z80 *R, register word Port);
    friend word LoopZ80(register Z80 *R);
    friend byte _RdZ80(Z80 *R, register word Addr);
};

#endif

