BANKLEN   EQU 3000h
CHANLEN   EQU 09h ; length of sound channel

UPMASK    EQU 01h
DOWNMASK  EQU 02h
LEFTMASK  EQU 04h
RIGHTMASK EQU 08h
AMASK     EQU 10h
BMASK     EQU 20h
XMASK     EQU 40h
YMASK     EQU 80h

PWMASK    EQU 3Fh
STMASK    EQU 0C0h

LOOP_NONE     EQU 00h
LOOP_NORMAL   EQU 01h
LOOP_REVERSE  EQU 02h
LOOP_PINGPONG EQU 03h

; Memory constants
RESET     EQU 0038h
VBLANK    EQU 0066h
BASERAM   EQU 0100h
SPRTILES  EQU 2F00h
BAKTILES  EQU 3F00h
IMAGE     EQU 4F00h
SPRITES   EQU 6B00h
INTTABLE  EQU 6F00h
BANKZERO  EQU 7000h
BANKX_A   EQU 0A000h
BANKY_A   EQU 0D000h

; I/O constants
FREQLO    EQU 10h
FREQHI    EQU 11h
VOLUME    EQU 12h
CHANINFO  EQU 13h

PCMFREQLO EQU 2Ch
PCMFREQHI EQU 2Dh
PCMOFFLO  EQU 2Eh
PCMOFFHI  EQU 2Fh
PCMSTRTLO EQU 30h
PCMSTRTHI EQU 31h
PCMENDLO  EQU 32h
PCMENDHI  EQU 33h
PCMINFO   EQU 34h

CONTROL1  EQU 35h
CONTROL2  EQU 36h

VPLEFT    EQU 37h
VPTOP     EQU 38h
VPRIGHT   EQU 39h
VPBOTTOM  EQU 3Ah
TILEPITCH EQU 3Bh

HPANNING  EQU 3Ch
VPANNING  EQU 3Dh
SCANLINE  EQU 3Eh

CURBANKX  EQU 3Fh
CURBANKY  EQU 40h

PALENTRY  EQU 41h
PAL_LO    EQU 42h
PAL_HI    EQU 43h

RNDSEED   EQU 44h
RAND      EQU 45h

VPBKGND   EQU 46h
NVPBKGND  EQU 47h

DEBUGBYTE EQU 50h
DEBUGCHAR EQU 51h
DEBUGINT  EQU 52h

; macros
RGBL    macro dest16, red, green, blue
  ld  dest16, [[red/8] SHL 11] + [[green/4] SHL 5] + [blue/8]
endm

RGBD    macro red, green, blue
  dw  [[red/8] SHL 11] + [[green/4] SHL 5] + [blue/8]
endm

