#include <windows.h>
#include <fstream.h>
#include "IntrFace\CDDraw.h"
#include "IntrFace\CDInput.h"
#include "Eclair.h"
#include "Output.h"
#include "Debug.h"

using namespace GameLib;

Eclair    g_Emu;
HWND      g_hWnd;
HINSTANCE g_hInst;
bool      g_bFocus, g_bQuitApp, g_bInitDone;
CDDraw    g_Cdraw;
CDInput   g_Cinput; 
CDIKeyboard Cdkeyboard;

int InitAppWindow(HINSTANCE hInst, int iCmdShow);
int InitInput();
void KBCallback(CDIDevice *dev);
long CALLBACK WindowProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam);

int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrev, PSTR szCmd, int iCmdShow)
{
  MSG msg;
  ifstream file;
  int err;

  SetPriorityClass(GetCurrentProcess(), HIGH_PRIORITY_CLASS);

  file.open(szCmd, ios::in | ios::binary | ios::nocreate);
  if(file.fail())
  {
    MsgBox("Unable to open %s for reading.", szCmd);
    return 1;
  }
  g_Emu.LoadROM(file);

  err = InitAppWindow(hInst, iCmdShow);
  if(err)
  {
    MsgBox("Error creating window.", err);
    return 1;
  }
  err = InitInput();
  if(err)
  {
    MsgBox("Error initializing DInput.");
    return 1;
  }
  if(g_Cdraw.Init(g_hWnd))
  {
    MsgBox("DirectDraw init failed.");
    return 1;
  }
  if(g_Cdraw.SetMode(320, 240, CDD_16BIT, CDD_FULLSCREEN, CDD_SINGLE))
  {
    MsgBox("DirectDraw cant set 320x240x16bpp!");
    return 1;
  }
  if(InitInput())
  {
    MsgBox("Can't initialize input.");
    return 1;
  }
  if(InitOutput())
  {
    MsgBox("Can't initialize output devices.");
    return 1;
  }

  g_Emu.SetDraw(Draw);
  g_Emu.SetSound(Sound);
  g_Cdraw.UpdateWindowed();
  g_bInitDone = true;

  while(!g_bQuitApp)
  {
    if (PeekMessage(&msg, g_hWnd, 0, 0, PM_REMOVE))
    {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
    else
    {
      if(g_bFocus) g_Emu.DoScan();
      else GetMessage(&msg, g_hWnd, 0, 0);
    }
  }

  g_Cdraw.RestoreMode();
  g_Cdraw.Deinit();

  return 0;
}

int InitAppWindow(HINSTANCE hInst, int iCmdShow)
{
  WNDCLASS    wc;
  char       *AppName  = "Eclair";
  char       *AppTitle = "Eclair Emulator";

  g_hInst = hInst;

  // Set up and register window class
  wc.style = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc    = WindowProc;
  wc.cbClsExtra     = 0;
  wc.cbWndExtra     = 0;
  wc.hInstance      = hInst;
  wc.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
  wc.hCursor        = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground  = (HBRUSH)GetStockObject(BLACK_BRUSH);
  wc.lpszMenuName   = NULL;
  wc.lpszClassName  = AppName;
  if (!RegisterClass(&wc)) return 1;

  // Create a window
  g_hWnd = CreateWindowEx(WS_EX_TOPMOST, AppName, AppTitle, WS_POPUP, 0, 0,
                     GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN),
                     //330, 250,
                     NULL, NULL, hInst, NULL);
  if(g_hWnd == NULL) return 1;
  ShowWindow(g_hWnd, SW_SHOWMAXIMIZED);
  //ShowWindow(g_hWnd, iCmdShow);

  return 0;
}

int InitInput()
{
   if (g_Cinput.Init(g_hWnd, g_hInst))
      return 1;

   Cdkeyboard.Buffered = TRUE;
   Cdkeyboard.Callback = KBCallback;
   if (g_Cinput.InitDevice(&Cdkeyboard, CDI_KEYBOARD,
                          DISCL_NONEXCLUSIVE | DISCL_FOREGROUND))
    return 2;
   g_Cinput.Acquire(&Cdkeyboard);

   if (g_Cinput.InitThread()) return 3;

   return 0;
}

void KBCallback(CDIDevice *dev)
{
  DIDEVICEOBJECTDATA dod[16];
  DWORD i, num = 16;
  HRESULT hRet;

  if(dev == NULL) return;

  while(TRUE)
  {
    hRet = dev->pDIDev->GetDeviceData(sizeof(DIDEVICEOBJECTDATA), dod, &num, 0);
    if (hRet == DIERR_NOTACQUIRED || hRet == DIERR_INPUTLOST)
    {
      hRet = dev->pDIDev->Acquire();
      if (FAILED(hRet)) break;
    }
    else break;
  }
  if (FAILED(hRet)) return;

  for(i=0;i<num;i++)
  {
    switch(dod[i].dwOfs)
    {
      case DIK_ESCAPE: g_bQuitApp = true; break;
      case DIK_UP:     g_Emu.Press(0, BTN_UP,    dod[i].dwData & 0x80); break;
      case DIK_DOWN:   g_Emu.Press(0, BTN_DOWN,  dod[i].dwData & 0x80); break;
      case DIK_LEFT:   g_Emu.Press(0, BTN_LEFT,  dod[i].dwData & 0x80); break;
      case DIK_RIGHT:  g_Emu.Press(0, BTN_RIGHT, dod[i].dwData & 0x80); break;
      case DIK_Z:      g_Emu.Press(0, BTN_A,     dod[i].dwData & 0x80); break;
      case DIK_X:      g_Emu.Press(0, BTN_B,     dod[i].dwData & 0x80); break;
      case DIK_A:      g_Emu.Press(0, BTN_X,     dod[i].dwData & 0x80); break;
      case DIK_S:      g_Emu.Press(0, BTN_Y,     dod[i].dwData & 0x80); break;
    }
  }
} /* KBCallback */

long CALLBACK WindowProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
  switch(iMsg)
  {
    case WM_CREATE:
      g_bFocus = FALSE;
      return 0;

    case WM_ACTIVATE:
      g_bFocus = !(LOWORD(wParam) == WA_INACTIVE);
      if(g_bFocus && g_bInitDone) g_Cinput.Acquire(&Cdkeyboard);
      return 0;
  
    case WM_MOUSEMOVE:
      ShowCursor(FALSE);
      return 0;

    case WM_SIZE:
    case WM_MOVE:
      g_Cdraw.UpdateWindowed();
      return 0;

    case WM_DESTROY:
      PostQuitMessage(0);
      g_bQuitApp = true;
      return 0;
  }

   return DefWindowProc(hWnd, iMsg, wParam, lParam);
} /* WindowProc */
