include "eclair.inc"

org BANKZERO
; 64 byte Header
db  "Raster Effects Test Rom",0

org BANKZERO+64

start:
di
; set scanline interrupt vector
ld  HL, scanint
ld  (INTTABLE+0h), HL

; set viewport background to 1
ld  A, 1
out (VPBKGND), A
; and border background to 2
inc A
out (NVPBKGND), A

; set viewport to 1/4 the screen, centered
ld  A, 14
out (VPTOP),  A
ld  A, 16
out (VPLEFT), A
ld  A, 42
out (VPBOTTOM), A
ld  A, 48
out (VPRIGHT),  A

im 2
ei
mainloop:
jr mainloop

scanint:
; changing palette entry 1
ld  A, 1
out (PALENTRY), A

; inc the low byte
ld  C,  PAL_LO
in  B,  (C)
inc B
out (C),  B

; dec the high byte
push AF
push BC
inc C
in  B, (C)
dec B
ld  A, 1
out (PALENTRY), A
out (C),  B

; now changing entry 2
in  A,  (RAND)
out (PAL_LO),  A
in  A,  (RAND)
out (PAL_HI),  A

pop BC
pop AF
ei
reti

; Initial IP address (relative to bank start)
org BANKZERO+BANKLEN-2
dw  64

