include "eclair.inc"

org BANKZERO
; 64 byte Header
db  "Sound Test Rom",0

org BANKZERO+64

start:
; install vblank handler
ld  HL, VBLANK
ld  (HL), 0CDh  ; call
ld  HL, VBlankInt
ld  (VBLANK+1), HL
ld  HL, 45EDh   ; retn
ld  (VBLANK+3), HL

ld  C,  PCMFREQLO
ld  HL, 8000
out (C), L
inc C
out (C), H
inc C
ld  HL, Wave
out (C),  L
inc C
out (C),  H
inc C
out (C), L
inc C
out (C), H
inc C
ld  HL, WaveEnd
out (C),  L
inc C
out (C),  H
inc C
ld  A,  LOOP_NORMAL
out (C),   A

ld  A, 20h
out (CHANINFO), A
ld  A, 80h
out (FREQLO), A
ld  A, 0FFh
out (VOLUME), A
mainloop:
jr  mainloop

VBlankInt:
push AF
push BC
push HL

in  A, (CONTROL1)
ld  B, A

and BMASK
jr  z, testleft

ld  A, 20h
out (CHANINFO), A
ld  A, 0FFh
out (VOLUME), A
ld  A, 80h
out (FREQLO), A
ld  A, 00h
out (FREQHI), A

.testleft
in  A, (FREQLO)
ld  L, A
in  A, (FREQHI)
ld  H, A

ld  A, B
and LEFTMASK
jr  z, testright
dec HL

.testright
ld  A, B
and RIGHTMASK
jr  z, testup
inc HL

.testup
ld  A, L
out (FREQLO), A
ld  A, H
out (FREQHI), A
in  A, (VOLUME)
ld  C, A

ld  A, B
and UPMASK
jr  z, testdown
inc C

.testdown
ld  A, B
and DOWNMASK
jr  z, testa
dec C

.testa
ld  A, C
out (VOLUME), A
ld  C, CHANINFO
in  H, (C)
ld  L, H
ld  A, B
and AMASK
jr  z, testx
ld  A, L
and STMASK
add A, 40h
ld  L, A

.testx
ld  A, H
and PWMASK
or  L
ld  H, A
and PWMASK
ld  L, A

ld  A, B
and XMASK
jr  z, testy
inc L
ld  A, L
cp  40h
jr  nz, testy
ld  L, 0

.testy
ld  A, B
and YMASK
jr  z, endl
dec L
ld  A, L
cp  0FFh
jr  nz, endl
ld  L, 3Fh

.endl
ld  A, H
and STMASK
or  L
out (C), A

pop HL
pop BC
pop AF
ret

Wave:
include "hello.inc"
WaveEnd:

; Initial IP address (relative to bank start)
org BANKZERO+BANKLEN-2
dw  64

