include "eclair.inc"

NUMTILES    EQU 2
NUMSPRITES  EQU 8
PALENTRIES  EQU 3

org BANKZERO
; 64 byte Header
db  "Sprites Test Rom",0

org BANKZERO+64

start:
; install vblank handler
ld  HL, VBLANK
ld  (HL), 0CDh  ; call
ld  HL, VBlankInt
ld  (VBLANK+1), HL
ld  HL, 45EDh   ; retn
ld  (VBLANK+3), HL

; set palette
ld  HL, Palette
ld  B,  PALENTRIES
ld  A,  1
out (PALENTRY), A
.palloop
ld  A,  (HL)
out (PAL_LO), A
inc HL
ld  A,  (HL)
out (PAL_HI), A
inc HL
djnz  palloop

; set background colors
ld A, 1
out (VPBKGND), A
out (NVPBKGND),A

; load sprite tiles from rom into memory
ld  DE, SPRTILES
ld  HL, SpriteTiles
ld  BC, NUMTILES*16
ldir

; load sprite data from rom into memory
ld  DE, SPRITES
ld  HL, SpriteData
ld  BC, NUMSPRITES*4
ldir

mainloop:
jr  mainloop

Palette:
RGBD  0, 0, 0
RGBD  0, 128, 128
RGBD  255, 0, 0

SpriteTiles:
db  3,2,2,0  ; thing
db  2,3,0,2
db  2,0,0,2
db  0,2,2,0

db  0,2,2,0  ; circle
db  2,0,0,2
db  2,0,0,2
db  0,2,2,0

SpriteData:
; tile num, x, y, info(000abvhu)
db 0, 0,0,    01h
db 0, 255,0,  01h
db 0, 0,223,  01h
db 0, 255,223,01h
db 0, 64,64,  11h
db 0, 128,64, 13h
db 0, 64,128, 15h
db 0, 128,128,17h

VBlankInt:
push  AF

in  A,  (VPANNING)
inc A
out (VPANNING), A
in  A, (RAND)
out (HPANNING), A

pop AF
ret

; Initial IP address (relative to bank start)
org BANKZERO+BANKLEN-2
dw  64


