include "eclair.inc"

PALENTRIES  EQU 3
NUMTILES    EQU 4

org BANKZERO
; 64 byte Header
db  "Tiles Test Rom",0

org BANKZERO+64

start:
; install vblank handler
ld  HL, VBLANK
ld  (HL), 0CDh  ; call
ld  HL, VBlankInt
ld  (VBLANK+1), HL
ld  HL, 45EDh   ; retn
ld  (VBLANK+3), HL

; set palette
ld  HL, Palette
ld  B,  PALENTRIES
ld  A,  1
out (PALENTRY), A
.palloop
ld  A,  (HL)
out (PAL_LO), A
inc HL
ld  A,  (HL)
out (PAL_HI), A
inc HL
djnz  palloop

; set viewport background to black (color 1)
ld A, 1
out (VPBKGND), A

; load tiles from rom into memory
ld  DE, BAKTILES+16
ld  HL, Tiles
ld  BC, NUMTILES*16
ldir

; load image data from rom into memory
ld  HL, IMAGE
ld  BC, 7168
.fill
in  A, (RAND)
and 3
inc A
ld  (HL), A
inc HL
dec BC
ld  A,  B
or  C
jr  nz, fill


mainloop:
jr  mainloop

Palette:
RGBD  0, 0, 0
RGBD  0, 128, 128
RGBD  255, 0, 0

Tiles:
db  0,2,0,0
db  2,2,0,0
db  0,2,0,0
db  2,2,2,0

db  3,3,3,0
db  0,0,3,0
db  0,3,0,0
db  3,3,3,0

db  2,2,2,0
db  0,2,2,0
db  0,0,2,0
db  2,2,2,0

db  3,0,3,0
db  3,3,3,0
db  0,0,3,0
db  0,0,3,0

VBlankInt:
push AF
push BC

in  A, (HPANNING)
ld  C, A

in  A, (CONTROL1)
ld  B, A

; test for left
and LEFTMASK
jr  z, testright
dec C

.testright
ld  A, B
and RIGHTMASK
jr  z, testup
inc C

.testup
ld  A, C
out (HPANNING), A
in  A, (VPANNING)
ld  C, A
ld  A, B
and UPMASK
jr  z, testdown
dec C

.testdown
ld  A, B
and DOWNMASK
jr  z, endl
inc C

.endl
ld  A, C
out (VPANNING), A

pop BC
pop AF
ret

; Initial IP address (relative to bank start)
org BANKZERO+BANKLEN-2
dw  64

