#include "stdafx.h"
#include "AddrBook.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CAddrBook::CAddrBook()
{ bDirty = false;
  Load();
}

CAddrBook::~CAddrBook()
{ if(bDirty) Save();
}

int CAddrBook::AddEntry()
{ int ret = NumEntries();
  bDirty = true;
  Book.resize(ret+1);
  return ret;
}

int CAddrBook::DelEntry(int index)
{ assert(index >= 0 && index < Book.size());
  bDirty = true;
  std::vector<Entry>::iterator i = Book.begin();
  int num = index;
  while(num--) i++;
  Book.erase(i);
  return index;
}

const TCHAR * CAddrBook::GetName(int index)
{ assert(index >= 0 && index < Book.size());
  return Book[index].name.c_str();
}

const TCHAR * CAddrBook::SetName(int index, const TCHAR *name)
{ assert(index >= 0 && index < Book.size());
  bDirty = true;
  Book[index].name = name;
  return name;
}

const TCHAR * CAddrBook::GetAddress(int index)
{ assert(index >= 0 && index < Book.size());
  return Book[index].address.c_str();
}

const TCHAR * CAddrBook::SetAddress(int index, const TCHAR *addr)
{ assert(index >= 0 && index < Book.size());
  bDirty = true;
  Book[index].address = addr;
  return addr;
}

const TCHAR * CAddrBook::GetComment(int index)
{ assert(index >= 0 && index < Book.size());
  return Book[index].comment.c_str();
}

const TCHAR * CAddrBook::SetComment(int index, const TCHAR *txt)
{ assert(index >= 0 && index < Book.size());
  bDirty = true;
  Book[index].comment = txt;
  return txt;
}

int CAddrBook::GetPort(int index)
{ assert(index >= 0 && index < Book.size());
  return Book[index].port;
}

int CAddrBook::SetPort(int index, int port)
{ assert(index >= 0 && index < Book.size());
  bDirty = true;
  return Book[index].port = port;
}

CAddrBook::Entry CAddrBook::GetEntry(int index)
{ assert(index >= 0 && index < Book.size());
  return Book[index];
}

void CAddrBook::SetEntry(int index, Entry entry)
{ assert(index >= 0 && index < Book.size());
  Book[index] = entry;
}

void CAddrBook::Load()
{ FILE *file = Open(false);
  if(!file) return;
  int i, num;

  if(!fread(&num, sizeof(int), 1, file)) goto Done;
  Book.clear();
  Book.resize(num);
  for(i=0;i<num;i++)
  { Book[i].name    = ReadString(file);
    Book[i].address = ReadString(file);
    Book[i].comment = ReadString(file);
    fread(&Book[i].port,   sizeof(int),  1, file);
    fread(&Book[i].width,  sizeof(int),  1, file);
    fread(&Book[i].height, sizeof(int),  1, file);
    fread(&Book[i].scroll, sizeof(int),  1, file);
    fread(&Book[i].bEcho,  sizeof(bool), 1, file);
  }
  Done:
  fclose(file);
}

void CAddrBook::Save()
{ FILE *file = Open(true);
  if(!file) return;
  int i, num = NumEntries();

  fwrite(&num, sizeof(int), 1, file);
  for(i=0;i<num;i++)
  { WriteString(file, Book[i].name.c_str());
    WriteString(file, Book[i].address.c_str());
    WriteString(file, Book[i].comment.c_str());
    fwrite(&Book[i].port,   sizeof(int),  1, file);
    fwrite(&Book[i].width,  sizeof(int),  1, file);
    fwrite(&Book[i].height, sizeof(int),  1, file);
    fwrite(&Book[i].scroll, sizeof(int),  1, file);
    fwrite(&Book[i].bEcho,  sizeof(bool), 1, file);
  }
  fclose(file);
}
