#ifndef ADDRBOOK_H_INC
#define ADDRBOOK_H_INC

class CAddrBook
{ public:
    CAddrBook();
    ~CAddrBook();

  public:
    struct Entry
    { Entry() { port=23, width=80, height=25, scroll=8192, bEcho=true; }
      std::string name, address, comment;
      int         port, width, height, scroll;
      bool        bEcho;
    };

    int           AddEntry();
    int           DelEntry(int index);
    int           NumEntries() { return Book.size(); }

    const TCHAR * GetName(int index);
    const TCHAR * SetName(int index, const TCHAR *);
    const TCHAR * GetAddress(int index);
    const TCHAR * SetAddress(int index, const TCHAR *);
    const TCHAR * GetComment(int index);
    const TCHAR * SetComment(int index, const TCHAR *);
    int           GetPort(int index);
    int           SetPort(int index, int port);
    Entry         GetEntry(int index);
    void          SetEntry(int index, Entry entry);

  private:
    FILE *  Open(bool ovr) { return OpenFile(_T("addrbook.dat"), ovr); }
    void    Load();
    void    Save();

    std::vector<Entry> Book;

    bool bDirty;
};

#endif