#include "stdafx.h"
#include "AliasDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(CAliasDlg, CDialog)
  ON_COMMAND(IDC_ADD, OnAdd)
  ON_COMMAND(IDC_EDIT, OnEdit)
  ON_COMMAND(IDC_DELETE, OnDelete)
  ON_LBN_SELCHANGE(IDC_LIST, OnSelChange)
END_MESSAGE_MAP()

CAliasDlg::CAliasDlg() : CDialog(IDD_ALIASES, NULL)
{ List.Load();
}

BOOL CAliasDlg::OnInitDialog()
{ CDialog::OnInitDialog();
    
  GetDlgItem(IDC_ALIAS)->SendMessage(EM_LIMITTEXT, 255);
  GetDlgItem(IDC_REPLACE)->SendMessage(EM_LIMITTEXT, 255);

  int i, len = List.NumEntries();
  CListBox list;
  list.Attach(GetDlgItem(IDC_LIST)->m_hWnd);
  for(i=0;i<len;i++) list.AddString(List.GetAlias(i));
  list.SetCurSel(0);
  Load(list.GetCurSel());
  list.Detach();

  return TRUE;
}

void CAliasDlg::OnOK()
{ List.Save();
  CDialog::OnOK();
}

bool CAliasDlg::Validate()
{ CEdit edit;
  bool ret=true;

  edit.Attach(GetDlgItem(IDC_ALIAS)->m_hWnd);
  if(edit.LineLength() <= 0)
  { AfxMessageBox(_T("Please enter an alias."));
    ret = false;
    goto Done;
  }

  edit.Detach();
  edit.Attach(GetDlgItem(IDC_REPLACE)->m_hWnd);
  if(edit.LineLength() <= 0)
  { AfxMessageBox(_T("Please enter the replacement text."));
    ret = false;
    goto Done;
  }

  Done:
  if(!ret) edit.SetFocus();
  edit.Detach();
  return ret;
}

void CAliasDlg::Edit(int index)
{ TCHAR buf[256];
  List.SetAlias(index, GetLine(IDC_ALIAS, buf));
  List.SetReplace(index, GetLine(IDC_REPLACE, buf));
}

void CAliasDlg::Load(int index)
{ if(index<0)
  { GetDlgItem(IDC_ALIAS)->SetWindowText(_T(""));
    GetDlgItem(IDC_REPLACE)->SetWindowText(_T(""));
  }
  else
  { GetDlgItem(IDC_ALIAS)->SetWindowText(List.GetAlias(index));
    GetDlgItem(IDC_REPLACE)->SetWindowText(List.GetReplace(index));
  }
}

TCHAR * CAliasDlg::GetLine(int id, TCHAR *buf)
{ GetDlgItem(id)->GetWindowText(buf, 256);
  return buf;
}

int CAliasDlg::Item()
{ int i = GetDlgItem(IDC_LIST)->SendMessage(LB_GETCURSEL);
  if(i == -1) AfxMessageBox(_T("Please select an item!"));
  return i;
}

void CAliasDlg::OnAdd()
{ if(!Validate()) return;
  TCHAR buf[256];
  CListBox list;
  int i = List.AddEntry();
  list.Attach(GetDlgItem(IDC_LIST)->m_hWnd);
  list.AddString(GetLine(IDC_ALIAS, buf));
  list.SetCurSel(i);
  list.Detach();
  Edit(i);
}

void CAliasDlg::OnEdit()
{ if(!Validate()) return;
  int i = Item();
  if(i == -1) return;

  TCHAR buf[256];
  CListBox list;
  list.Attach(GetDlgItem(IDC_LIST)->m_hWnd);
  list.DeleteString(i);
  list.InsertString(i, GetLine(IDC_ALIAS, buf));
  list.SetCurSel(i);
  list.Detach();
  Edit(i);
}

void CAliasDlg::OnDelete()
{ int i = Item();
  if(i == -1) return;
  List.DelEntry(i);
  CListBox list;
  list.Attach(GetDlgItem(IDC_LIST)->m_hWnd);
  list.DeleteString(i);
  list.SetCurSel(i-1);
  list.Detach();
  Load(i-1);
}

void CAliasDlg::OnSelChange()
{ Load(GetDlgItem(IDC_LIST)->SendMessage(LB_GETCURSEL));
}
