#include "stdafx.h"
#include "AliasLst.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CAliasList::CAliasList()
{ bDirty = false;
}

int CAliasList::AddEntry()
{ int ret = NumEntries();
  bDirty = true;
  List.resize(ret+1);
  return ret;
}

int CAliasList::DelEntry(int index)
{ assert(index >= 0 && index < List.size());
  bDirty = true;
  std::vector<Entry>::iterator i = List.begin();
  int num = index;
  while(num--) i++;
  List.erase(i);
  return index;
}

const TCHAR * CAliasList::GetAlias(int index)
{ assert(index >= 0 && index < List.size());
  return List[index].alias.c_str();
}

const TCHAR * CAliasList::SetAlias(int index, const TCHAR *alias)
{ assert(index >= 0 && index < List.size());
  bDirty = true;
  List[index].alias = alias;
  return alias;
}

const TCHAR * CAliasList::GetReplace(int index)
{ assert(index >= 0 && index < List.size());
  return List[index].replace.c_str();
}

const TCHAR * CAliasList::SetReplace(int index, const TCHAR *rep)
{ assert(index >= 0 && index < List.size());
  bDirty = true;
  List[index].replace = rep;
  return rep;
}

void CAliasList::Replace(TCHAR *str, int max)
{ CString &word = GetWord(str);
  for(int i=0;i<List.size();i++)
  { if(word == List[i].alias.c_str())
    { int rlen=List[i].replace.length(), wlen=word.GetLength(), slen=_tcslen(str);
      if(wlen+rlen+slen+1>max)
      { AfxMessageBox(_T("Macro expansion overflow!"));
        return;
      }
      memmove(str+rlen, str+wlen, slen-wlen+1);
      CharToTCharBuf(str, List[i].replace.c_str(), rlen);
      Replace(str, max);
      break;
    }
  }
}

CAliasList& CAliasList::operator=(CAliasList& rhs)
{ List   = rhs.List;
  bDirty = true;
  return *this;
}

void CAliasList::Load()
{ FILE *file = Open(false);
  if(!file) return;
  int i, num;

  if(!fread(&num, sizeof(int), 1, file)) goto Done;
  List.clear();
  List.resize(num);

  for(i=0;i<num;i++)
  { List[i].alias   = ReadString(file);
    List[i].replace = ReadString(file);
  }
  Done:
  fclose(file);
}

void CAliasList::Save()
{ if(bDirty)
  { int i, len = NumEntries();
    FILE *file = Open(true);
    if(!file) return;
    fwrite(&len, sizeof(int), 1, file);
    for(i=0;i<len;i++)
    { WriteString(file, List[i].alias.c_str());
      WriteString(file, List[i].replace.c_str());
    }
    fclose(file);
  }
}
