#ifndef ALIASLST_H_INC
#define ALIASLST_H_INC

class CAliasList
{ public:
    CAliasList();

  public:
    struct Entry
    { std::string alias, replace;
    };

    int           AddEntry();
    int           DelEntry(int index);
    int           NumEntries() { return List.size(); }
    void          Load();
    void          Save();

    const TCHAR * GetAlias(int index);
    const TCHAR * SetAlias(int index, const TCHAR *);
    const TCHAR * GetReplace(int index);
    const TCHAR * SetReplace(int index, const TCHAR *);
    void          Replace(TCHAR *str, int max);

    CAliasList& operator=(CAliasList& rhs);

  private:
    FILE * Open(bool ovr) { return OpenFile(_T("alias.dat"), ovr); }

    std::vector<Entry> List;
    bool bDirty;
};

#endif