#include "stdafx.h"
#include "ColorDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(CColorDlg, CDialog)
  ON_COMMAND_RANGE(IDC_COLOR0, IDC_COLOR15, OnClick)
  ON_WM_CTLCOLOR()
  ON_WM_DRAWITEM()
END_MESSAGE_MAP()

CColorDlg::CColorDlg() : CDialog(IDD_COLORS, NULL)
{ FILE *file = Open(false);
  if(file)
  { fread(&defFore, 4, 1, file);
    fread(&defBack, 4, 1, file);
    fread(Colors, sizeof(Colors), 1, file);
    fclose(file);
  }
  else 
  { memcpy(Colors, g_Colors, 16*sizeof(COLORREF));
    defFore  = g_defFore, defBack = g_defBack;
    btnBrush = NULL;
  }
}

CColorDlg::~CColorDlg()
{ if(btnBrush) ::DeleteObject(btnBrush);
}

void CColorDlg::OnOK()
{ FILE *file = Open(true);
  if(!file) return;
  defFore = GetDlgItem(IDC_FORE)->SendMessage(CB_GETCURSEL);
  defBack = GetDlgItem(IDC_BACK)->SendMessage(CB_GETCURSEL);

  if(file)
  { fwrite(&defFore, 4, 1, file);
    fwrite(&defBack, 4, 1, file);
    fwrite(Colors, sizeof(Colors), 1, file);
    fclose(file);
  }
  
  CDialog::OnOK();
}

BOOL CColorDlg::OnInitDialog()
{ CDialog::OnInitDialog();
  TCHAR buf[16];
  int   id;
  CWnd *wnd;

  wnd = GetDlgItem(IDC_BACK);
  for(id=IDC_COLOR0;id<=IDC_COLOR7;id++)
  { GetDlgItem(id)->GetWindowText(buf, 16);
    wnd->SendMessage(CB_ADDSTRING, 0, (LPARAM)buf);
  }
  wnd->SendMessage(CB_SETCURSEL, defBack);

  wnd = GetDlgItem(IDC_FORE);
  for(id=IDC_COLOR0;id<=IDC_COLOR7;id++)
  { GetDlgItem(id)->GetWindowText(buf, 16);
    wnd->SendMessage(CB_ADDSTRING, 0, (LPARAM)buf);
  }
  for(id=IDC_COLOR0;id<=IDC_COLOR7;id++)
  { GetDlgItem(id)->GetWindowText(buf, 16);
    wnd->SendMessage(CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)(CString(_T("Bold ")) + buf));
  }
  wnd->SendMessage(CB_SETCURSEL, defFore);
  return TRUE;
}

void CColorDlg::OnClick(UINT nID)
{ CHOOSECOLOR cc;
  COLORREF    custom[16];
  memset(&cc, 0, sizeof(cc));
  cc.lStructSize  = sizeof(cc);
  cc.hInstance    = m_hWnd;
  cc.rgbResult    = Colors[nID-IDC_COLOR0];
  cc.Flags        = CC_ANYCOLOR | CC_FULLOPEN | CC_RGBINIT;
  cc.lpCustColors = custom;
  if(::ChooseColor(&cc))
  { Colors[nID-IDC_COLOR0] = cc.rgbResult;
    GetDlgItem(nID)->Invalidate();
  }
}

HBRUSH CColorDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{ HBRUSH ret = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
  int id = pWnd->GetDlgCtrlID();

  if(id>=IDC_COLOR0 && id<=IDC_COLOR15)
  { long i = id-IDC_COLOR0;
    pDC->SetTextColor(RGB(GetRValue(Colors[i])+128, GetGValue(Colors[i])+128,
                          GetBValue(Colors[i])+128));
    pDC->SetBkMode(TRANSPARENT);
    if(btnBrush) ::DeleteObject(btnBrush);
    return btnBrush = ::CreateSolidBrush(Colors[i]);
  }
  return ret;
}

void CColorDlg::OnDrawItem(int nID, DRAWITEMSTRUCT *dis)
{ if(nID>=IDC_COLOR0 && nID<=IDC_COLOR15)
  { TCHAR buf[16];
    ::GetWindowText(dis->hwndItem, buf, 16);
    ::DrawText(dis->hDC, buf, -1, &dis->rcItem, DT_CENTER|DT_VCENTER|DT_SINGLELINE);
  }
  CDialog::OnDrawItem(nID, dis);
}
