#include "stdafx.h"
#include "ConnDlg.h"
#include "PropDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(CConnDlg, CDialog)
  ON_COMMAND(IDC_ADD, OnAdd)
  ON_COMMAND(IDC_EDIT, OnEdit)
  ON_COMMAND(IDC_DELETE, OnDelete)
  ON_COMMAND(IDC_SETTINGS, OnSettings)
  ON_LBN_SELCHANGE(IDC_LIST, OnSelChange)
END_MESSAGE_MAP()

CConnDlg::CConnDlg() : CDialog(IDD_CONNECT, NULL)
{
}

BOOL CConnDlg::OnInitDialog()
{ CDialog::OnInitDialog();
  GetDlgItem(IDC_NAME)->SendMessage(EM_LIMITTEXT, 255);
  GetDlgItem(IDC_ADDRESS)->SendMessage(EM_LIMITTEXT, 255);
  GetDlgItem(IDC_COMMENT)->SendMessage(EM_LIMITTEXT, 255);
  GetDlgItem(IDC_PORT)->SendMessage(EM_LIMITTEXT, 5);

  int i, len = Book.NumEntries();
  CListBox list;
  list.Attach(GetDlgItem(IDC_LIST)->m_hWnd);
  for(i=0;i<len;i++) list.AddString(Book.GetName(i));
  list.SetCurSel(0);
  Load(list.GetCurSel());
  list.Detach();

  return TRUE;
}

bool CConnDlg::Validate()
{ TCHAR buf[8];
  CEdit edit;
  int port;
  bool ret=true;

  edit.Attach(GetDlgItem(IDC_NAME)->m_hWnd);
  if(edit.LineLength() <= 0)
  { AfxMessageBox(_T("Please enter a name."));
    ret = false;
    goto Done;
  }

  edit.Detach();
  edit.Attach(GetDlgItem(IDC_ADDRESS)->m_hWnd);
  if(edit.LineLength() <= 0)
  { AfxMessageBox(_T("Please enter an address."));
    ret = false;
    goto Done;
  }

  port = atoi(GetLine(IDC_PORT, buf));
  if(port < 0 || port > 65535)
  { AfxMessageBox(_T("The port must be from 0 to 65535."));
    ret = false;
    goto Done;
  }

  Done:
  if(!ret) edit.SetFocus();
  edit.Detach();
  return ret;
}

void CConnDlg::Edit(int index)
{ TCHAR buf[256];
  Book.SetName(index, GetLine(IDC_NAME, buf));
  Book.SetAddress(index, GetLine(IDC_ADDRESS, buf));
  Book.SetComment(index, GetLine(IDC_COMMENT, buf));
  Book.SetPort(index, atoi(GetLine(IDC_PORT, buf)));
}

TCHAR * CConnDlg::GetLine(int id, TCHAR *buf)
{ GetDlgItem(id)->GetWindowText(buf, 256);
  return buf;
}

void CConnDlg::Load(int index)
{ if(index<0)
  { GetDlgItem(IDC_NAME)->SetWindowText(_T(""));
    GetDlgItem(IDC_ADDRESS)->SetWindowText(_T(""));
    GetDlgItem(IDC_COMMENT)->SetWindowText(_T(""));
    GetDlgItem(IDC_PORT)->SetWindowText(_T(""));
  }
  else
  { TCHAR buf[8];
    GetDlgItem(IDC_NAME)->SetWindowText(Book.GetName(index));
    GetDlgItem(IDC_ADDRESS)->SetWindowText(Book.GetAddress(index));
    GetDlgItem(IDC_COMMENT)->SetWindowText(Book.GetComment(index));
    wsprintf(buf, _T("%d"), Book.GetPort(index));
    GetDlgItem(IDC_PORT)->SetWindowText(buf);
  }
}

int CConnDlg::Item()
{ int i = GetDlgItem(IDC_LIST)->SendMessage(LB_GETCURSEL);
  if(i == -1) AfxMessageBox(_T("Please select an item!"));
  return i;
}

void CConnDlg::OnOK()
{ CListBox list;
  list.Attach(GetDlgItem(IDC_LIST)->m_hWnd);
  nSelection = list.GetCurSel();
  list.Detach();
  if(nSelection == -1) AfxMessageBox(_T("You must select a server to connect to!"));
  else CDialog::OnOK();
}

void CConnDlg::OnAdd()
{ if(!Validate()) return;
  TCHAR buf[256];
  CListBox list;
  int i = Book.AddEntry();
  list.Attach(GetDlgItem(IDC_LIST)->m_hWnd);
  list.AddString(GetLine(IDC_NAME, buf));
  list.SetCurSel(i);
  list.Detach();
  Edit(i);
}

void CConnDlg::OnEdit()
{ if(!Validate()) return;
  int i = Item();
  if(i == -1) return;

  TCHAR buf[256];
  CListBox list;
  list.Attach(GetDlgItem(IDC_LIST)->m_hWnd);
  list.DeleteString(i);
  list.InsertString(i, GetLine(IDC_NAME, buf));
  list.SetCurSel(i);
  list.Detach();
  Edit(i);
}

void CConnDlg::OnDelete()
{ int i = Item();
  if(i == -1) return;
  Book.DelEntry(i);
  CListBox list;
  list.Attach(GetDlgItem(IDC_LIST)->m_hWnd);
  list.DeleteString(i);
  list.SetCurSel(i-1);
  list.Detach();
  Load(i-1);
}

void CConnDlg::OnSettings()
{ int i = Item();
  if(i == -1) return;

  CPropDlg dlg(Book.GetEntry(i));
  if(dlg.DoModal() == IDOK)
  { Book.SetEntry(i, dlg.Entry);
    CListBox list;
    list.Attach(GetDlgItem(IDC_LIST)->m_hWnd);
    list.DeleteString(i);
    list.InsertString(i, dlg.Entry.name.c_str());
    list.SetCurSel(i);
    list.Detach();
    Load(i);
  }
}

void CConnDlg::OnSelChange()
{ Load(GetDlgItem(IDC_LIST)->SendMessage(LB_GETCURSEL));
}
