#include "stdafx.h"
#include "MainEdit.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(CMainEdit, CEdit)
  ON_WM_CHAR()
  ON_WM_KEYDOWN()
END_MESSAGE_MAP()

CMainEdit::CMainEdit()
{ histPos = 0;
  histMax = 10;
}

BOOL CMainEdit::Create(CWnd* pParent)
{ CEdit::Create(WS_CHILD|ES_AUTOHSCROLL|WS_BORDER, CRect(0, 0, 1, 20),
                pParent, IDC_MAINEDIT);
  SetLimitText(255);
  AutoSize();
  ShowWindow(SW_SHOW);
  return TRUE;
}

void CMainEdit::AutoSize()
{ CWnd *par = GetParent();
  CRect prect, mrect;
  par->GetClientRect(&prect);
  GetWindowRect(&mrect);

  SetWindowPos(&wndTop, prect.left, prect.bottom-mrect.Height(),
               prect.Width(), mrect.Height(), 0);
}

int CMainEdit::AddLine(const TCHAR *line)
{ int i = histMax-1;
  if(History[i]==line) return i;

  SString temp = History[0];
  memmove(History, History+1, (histMax-1)*sizeof(SString));
  History[histMax-1] = temp;
  History[i].Set(line);
  return i;
}

void CMainEdit::OnChar(UINT nChar, UINT nCount, UINT nFlags)
{ if(isdigit(nChar) && (nFlags&0xff)>0x10);
  else if(nChar == '\r')
  { TCHAR buf[4096];
    GetWindowText(buf, 4096);
    g_MyApp.Aliases.Replace(buf, 4096);
    GetParent()->Telnet.SendLine(buf);
    SetSel(0, -1);
    histPos = AddLine(buf);
  }
  else CEdit::OnChar(nChar, nCount, nFlags);
}

void CMainEdit::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{ if(nChar >= VK_NUMPAD0 && nChar <= VK_DIVIDE)
  { int i=nChar-VK_NUMPAD0;
    if(g_MyApp.Props.Keypad[i][0])
    { TCHAR buf[4096];
      _tcscpy(buf, g_MyApp.Props.Keypad[i]);
      SetWindowText(g_MyApp.Props.Keypad[i]);
      SetSel(0, -1);
      g_MyApp.Aliases.Replace(buf, 4096);
      GetParent()->Telnet.SendLine(buf);
    }
  }
  else if(nChar == VK_UP || nChar == VK_DOWN)
  { int old=histPos;
    if(nChar == VK_UP && histPos) histPos--;
    else if(nChar == VK_DOWN && histPos<histMax-1) histPos++;
    if(History[histPos].Length())
    { SetWindowText(History[histPos]);
      SetSel(0, -1);
    }
    else histPos=old;
  }
  else CEdit::OnKeyDown(nChar, nRepCnt, nFlags);
}
