#include "stdafx.h"
#include "MainFrm.h"
#include "MapFrame.h"
#include "PropDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(CMainFrm, CFrameWnd)
  ON_WM_PAINT()
  ON_WM_ERASEBKGND()
  ON_WM_MOUSEWHEEL()
  ON_WM_VSCROLL()
  ON_WM_SETFOCUS()
  ON_WM_SIZE()
  ON_COMMAND(ID_VIEW_SPECIFIC, OnViewMUD)
  ON_UPDATE_COMMAND_UI(ID_VIEW_SPECIFIC, OnViewMUDUpdate)
  ON_COMMAND(ID_VIEW_CLEAR, Clear)
  ON_COMMAND(ID_FILE_LOG, OnFileLog)
  ON_UPDATE_COMMAND_UI(ID_FILE_LOG, OnFileLogUpdate)
  ON_COMMAND(ID_VIEW_MAP, OnViewMap)
END_MESSAGE_MAP()

CMainFrm::CMainFrm()
{ Telnet.SetParent(this);
  Container.SetParent(this);
  Map    = NULL;
  Log    = NULL;
  cxChar = cyChar = cyPage = 1;

  CRect mrect, irect;
  Create(NULL, _T(APPNAME " v. " VERSIONSTR), WS_OVERLAPPEDWINDOW, rectDefault, NULL,
         MAKEINTRESOURCE(IDR_MAINFRAME));
  LoadAccelTable(MAKEINTRESOURCE(IDR_MAINFRAME));

  Font.CreatePointFont(100, _T("Courier New"));
  Input.Create(this);
  GetClientRect(&mrect);
  Input.GetWindowRect(&irect);
  mrect.bottom -= irect.Height();
  Scroll.Create(WS_CHILD|WS_VISIBLE|SBS_RIGHTALIGN|SBS_VERT, mrect, this, IDC_MAINSCROLL);
  GetWindowRect(&View);
  OnSize(SW_SHOW, View.Width(), View.Height());
  UpdateScroll(0);
}

CMainFrm::~CMainFrm()
{ delete Map;
}

void CMainFrm::UpdateScroll(int len)
{ static int oldlen;
  bool down=false;
  SCROLLINFO si;
  si.cbSize = sizeof(SCROLLINFO);
  si.fMask  = SIF_ALL;
  Scroll.GetScrollInfo(&si);
  si.nMin   = 0;
  si.nPage  = View.Height()/cyChar;
  if(si.nPos >= (int)(si.nMax-si.nPage)) down=true;
  si.nMax   = max(len, 0);
  if(down)
  { si.nPos = si.nMax-si.nPage+1;
    Invalidate();
  }
  else if(len<oldlen) si.nPos -= oldlen-len;
  if(si.nPos<0) si.nPos = 0;
  Scroll.SetScrollInfo(&si);
  oldlen = len;
}

void CMainFrm::PollTelnet()
{ if(Container.Changed()) UpdateScroll(Container.NumLines());
}

void CMainFrm::Clear()
{ Container.Clear();
  UpdateScroll(0);
  Invalidate();
}

void CMainFrm::Connect()
{ ApplyEntry();
  Telnet.Create();
  Telnet.Connect(Entry.address.c_str(), Entry.port);
} 

void CMainFrm::AddToLog(const TCHAR *str)
{ if(!Log) return;
  fwrite(str, _tcslen(str)*sizeof(TCHAR), 1, Log);
}

void CMainFrm::DoScroll(int lines, bool abs)
{ if(!lines) return;
  SCROLLINFO si;
  int dist, old;
  si.cbSize = sizeof(si);
  si.fMask  = SIF_POS|SIF_PAGE;
  Scroll.GetScrollInfo(&si);
  si.nPage  = cyPage;
  old = si.nPos;
  if(abs) si.nPos = lines;
  else si.nPos += lines;
  if(si.nPos > (int)(Container.NumLines()-si.nPage+1))
    si.nPos = Container.NumLines()-si.nPage+1;
  if(si.nPos < 0) si.nPos = 0;
  Scroll.SetScrollInfo(&si);
  if(dist = si.nPos-old)
  { CRect inv = View;
    int len = dist*cyChar;
    ScrollWindow(0, -len, View, View);
    if(len < 0) inv.bottom = len;
    else inv.top = inv.bottom-len;
    InvalidateRect(inv);
  }
}

void CMainFrm::ApplyEntry()
{ CRect w, c, s, i;
  GetWindowRect(w);
  GetClientRect(c);
  Scroll.GetWindowRect(s);
  Input.GetWindowRect(i);

  SetWindowPos(NULL, w.left, w.top,
               cxChar*Entry.width+s.Width()+w.Width()-c.Width(),
               cyChar*Entry.height+i.Height()+w.Height()-c.Height(),
               SWP_NOOWNERZORDER);
  Container.Resize(Entry.scroll);
}

void CMainFrm::OnSize(UINT nType, int cx, int cy)
{ CRect crect, irect, srect;
  GetClientRect(&crect);
  Input.GetWindowRect(&irect);
  Scroll.GetWindowRect(&srect);
  CFrameWnd::OnSize(nType, cx, cy);
  Input.AutoSize();
  Scroll.SetWindowPos(&wndTop, crect.right-srect.Width(), crect.top,
                      srect.Width(), crect.Height()-irect.Height(), 0);
  View = crect;
  View.bottom -= irect.Height();
  View.right  -= srect.Width();

  CClientDC cdc(this);
  CFont *old = cdc.SelectObject(&Font);
  TEXTMETRIC tm;
  cdc.GetTextMetrics(&tm);
  cdc.SelectObject(old);
  cxChar = tm.tmAveCharWidth;
  cyChar = tm.tmHeight + tm.tmExternalLeading;
  cyPage = View.Height()/cyChar;
  Invalidate();
}

BOOL CMainFrm::OnEraseBkgnd(CDC *pDC)
{ CBrush brush;
  brush.CreateSolidBrush(RGB(0,0,0));
  pDC->FillRect(&View, &brush);
  return TRUE;
}

void CMainFrm::OnSetFocus(CWnd *)
{ Input.SetFocus();
}

void CMainFrm::OnPaint()
{ SCROLLINFO si;
  CPaintDC cdc(this);
  CFont   *old = cdc.SelectObject(&Font);
  int i, page  = cyPage+1;

  Scroll.GetScrollInfo(&si, SIF_POS);
  i = si.nPos;
  if(page > Container.NumLines()-i) page = Container.NumLines()-i;
  Container.Render(&cdc, i, page, 0, cxChar, cyChar);
  cdc.SelectObject(old);
}

void CMainFrm::OnVScroll(UINT sbCode, UINT nPos, CWnd *pBar)
{ int  lines=0;
  bool abs=false;

  switch(sbCode)
  { case SB_BOTTOM:   lines =  Container.NumLines()-cyPage, abs=true; break;
    case SB_TOP:      lines =  0, abs=true; break;
    case SB_LINEDOWN: lines =  1;      break;
    case SB_LINEUP:   lines = -1;      break;
    case SB_PAGEDOWN: lines =  cyPage; break;
    case SB_PAGEUP:   lines = -cyPage; break;
    case SB_THUMBPOSITION: case SB_THUMBTRACK: lines=nPos, abs=true; break;
  }
  DoScroll(lines, abs);
}

BOOL CMainFrm::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{ DoScroll(-3*zDelta/WHEEL_DELTA, false);
  return TRUE;
}

void CMainFrm::OnViewMUD()
{ CPropDlg dlg(Entry);
  if(dlg.DoModal() == IDOK)
  { CAddrBook book;
    book.SetEntry(nEntry, Entry=dlg.Entry);
    ApplyEntry();
  }
}

void CMainFrm::OnViewMUDUpdate(CCmdUI *pUI)
{ pUI->Enable(Telnet.Connected());
}

void CMainFrm::OnFileLog()
{ if(Log)
  { fclose(Log);
    Log = NULL;
  }
  else
  { TCHAR fn[MAX_PATH];
    OPENFILENAME ofn;
    fn[0] = 0;
    memset(&ofn, 0, sizeof(ofn));
    ofn.lStructSize  = sizeof(ofn);
    ofn.hwndOwner    = m_hWnd;
    ofn.lpstrFilter  = _T("Text files (*.txt)\0*.txt\0All files (*.*)\0*.*\0\0");
    ofn.nFilterIndex = 1;
    ofn.lpstrFile    = fn;
    ofn.nMaxFile     = MAX_PATH;
    ofn.lpstrTitle   = _T("Log File");
    ofn.Flags        = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST;
    if(GetOpenFileName(&ofn)) Log = fopen(fn, _T("at+"));
  }
}

void CMainFrm::OnFileLogUpdate(CCmdUI *pUI)
{ pUI->SetCheck(Log!=NULL);
}

void CMainFrm::OnViewMap()
{ if(!Map) Map = new CMapFrame(this);
  Map->ShowWindow(SW_SHOW);
  Map->SetFocus();
}

void CMainFrm::OnCloseMap()
{ Map = NULL;
}
