#ifndef MAINFRM_H_INC
#define MAINFRM_H_INC

#include "MainEdit.h"
#include "Telnet.h"
#include "TextCont.h"
#include "AddrBook.h"

class CMapFrame;
class CMainFrm : public CFrameWnd
{ public:
    CMainFrm();
    virtual ~CMainFrm();

    void UpdateScroll(int len);
    void PollTelnet();
    void Clear();
    void Connect();
    void AddToLog(const TCHAR *);
    void OnCloseMap();

    CTextCont         Container;
    CTelnet           Telnet;
    CAddrBook::Entry  Entry;
    int               nEntry;

  private:
    void        DoScroll(int lines, bool abs);
    void        ApplyEntry();

    CMainEdit   Input;
    CScrollBar  Scroll;
    CRect       View;
    CFont       Font;
    CMapFrame  *Map;
    FILE       *Log;
    int         cxChar, cyChar, cyPage;

  DECLARE_MESSAGE_MAP()
    afx_msg void OnSize(UINT, int, int);
    afx_msg BOOL OnEraseBkgnd(CDC *pDC);
    afx_msg void OnSetFocus(CWnd *);
    afx_msg void OnPaint();
    afx_msg void OnVScroll(UINT sbCode, UINT nPos, CWnd *pBar);
    afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
    afx_msg void OnViewMUD();
    afx_msg void OnViewMUDUpdate(CCmdUI *pUI);
    afx_msg void OnFileLog();
    afx_msg void OnFileLogUpdate(CCmdUI *pUI);
    afx_msg void OnViewMap();
};

#endif
