#ifndef MAP_H_INC
#define MAP_H_INC

enum TileFlags
{ TF_TYPE=0x0F, TF_N=0x10,  TF_NE=0x20,  TF_E=0x40, TF_SE=0x80, TF_S=0x100,
  TF_SW=0x200,  TF_W=0x400, TF_NW=0x800, TF_DRINK=0x1000, TF_FOOD=0x2000
};
enum TileTypes
{ TT_NORMAL, TT_ARMORY, TT_WEAPONS, TT_GSTORE, TT_INN, TT_GATE
};

struct CTile
{ CTile()  { flags = 0; }
  void Load(FILE *);
  void Save(FILE *);

  SString name, desc;
  int     flags;
};

class CLevel
{ public:
    CLevel();
    ~CLevel();
    void Load(FILE *);
    void Save(FILE *);

    void Resize(int wid, int hei);

  private:
    CTile   *Layout;
    int      Wid, Hei;
};

class CMap
{ public:
    CMap();
    ~CMap();
    void Load(FILE *);
    void Save(FILE *);

  private:
};

#endif
