#include "stdafx.h"
#include "MapFrame.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(CMapFrame, CFrameWnd)
  ON_WM_ERASEBKGND()
  ON_COMMAND(ID_VIEW_MUD,  OnViewMUD)
  ON_COMMAND(ID_MAP_CLOSE, OnMapClose)
END_MESSAGE_MAP()

CMapFrame::CMapFrame(CMainFrm *par)
{ Parent = par;
  CRect rect = rectDefault, prect;
  par->GetWindowRect(prect);
  rect.right  = rect.left + prect.Width()*2/3;
  rect.bottom = rect.top  + prect.Height()*2/3;
  Create(NULL, _T("MuddyMap"), WS_OVERLAPPEDWINDOW, rect, NULL,
         MAKEINTRESOURCE(IDR_MAPFRAME));
  LoadAccelTable(MAKEINTRESOURCE(IDR_MAPFRAME));
  ShowWindow(SW_SHOW);
}

CMapFrame::~CMapFrame()
{ Parent->OnCloseMap();
}

BOOL CMapFrame::OnEraseBkgnd(CDC *pDC)
{ RECT rect;
  GetClientRect(&rect);
  ::FillRect(pDC->m_hDC, &rect, (HBRUSH)GetStockObject(BLACK_BRUSH));
  return TRUE;
}

void CMapFrame::OnViewMUD()
{ Parent->ShowWindow(SW_SHOW);
  Parent->SetFocus();
}

void CMapFrame::OnMapClose()
{ delete this;
}
