#include "stdafx.h"
#include "MyApp.h"
#include "MainFrm.h"
#include "ConnDlg.h"
#include "AliasDlg.h"
#include "ColorDlg.h" 
#include "AddrBook.h"
#include "AboutDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(CMyApp, CWinApp)
  ON_COMMAND(ID_FILE_CONNECT, OnFileConnect)
  ON_COMMAND(ID_FILE_DISCONNECT, OnFileDisconnect)
  ON_UPDATE_COMMAND_UI(ID_FILE_DISCONNECT, OnFileDisconnectUpdate)
  ON_COMMAND(ID_VIEW_ALIASES, OnViewAliases)
  ON_COMMAND(ID_VIEW_COLORS, OnViewColors)
  ON_COMMAND(ID_VIEW_GLOBAL, OnViewProgram)
  ON_COMMAND(ID_APP_ABOUT, OnHelpAbout)
END_MESSAGE_MAP()

CMyApp::CMyApp()
{ TCHAR *cmdline = GetCommandLine(), *pos = _tcschr(cmdline+1, _T('\"'));
  if(pos) *pos = 0, pos = _tcsrchr(cmdline, _T('\\'));
  if(pos)
  { int len = pos - cmdline;
    AppPath = new TCHAR[len+1];
    memcpy(AppPath, cmdline+1, (len)*sizeof(TCHAR));
    AppPath[len] = 0;
  }
  else
  { AppPath = new TCHAR[3];
    _tcscpy(AppPath, _T(".\\"));
  }

  Aliases.Load();
  Props.Load();

  CColorDlg dlg;
  memcpy(g_Colors, dlg.Colors, 16*sizeof(COLORREF));
  g_defFore = dlg.defFore, g_defBack = dlg.defBack;
}

CMyApp::~CMyApp()
{ delete[] AppPath;
}

BOOL CMyApp::InitInstance()
{ m_pMainWnd = new CMainFrm;
  m_pMainWnd->ShowWindow(SW_SHOW);
  m_pMainWnd->UpdateWindow();
  return AfxSocketInit();
}

BOOL CMyApp::OnIdle(long count)
{ GetWindow()->PollTelnet();
  return TRUE;
}

void CMyApp::OnFileConnect()
{ CConnDlg dlg;
  if(dlg.DoModal() == IDOK)
  { CMainFrm *wnd = GetWindow();
    OnFileDisconnect();
    wnd->Entry = dlg.Book.GetEntry(wnd->nEntry=dlg.nSelection);
    wnd->Connect();
  }
}

void CMyApp::OnFileDisconnect()
{ GetWindow()->Telnet.Close();
  GetWindow()->Clear();
}

void CMyApp::OnFileDisconnectUpdate(CCmdUI *pUI)
{ pUI->Enable(GetWindow()->Telnet.Connected());
}

void CMyApp::OnViewAliases()
{ CAliasDlg dlg;
  if(dlg.DoModal() == IDOK) Aliases = dlg.List;
}

void CMyApp::OnViewColors()
{ CColorDlg dlg;
  if(dlg.DoModal() == IDOK)
  { memcpy(g_Colors, dlg.Colors, 16*sizeof(COLORREF));
    GetWindow()->Invalidate();
    g_defFore = dlg.defFore;
    g_defBack = dlg.defBack;
  }
}

void CMyApp::OnViewProgram()
{ CProgDlg dlg(Props);
  if(dlg.DoModal() == IDOK) Props = dlg.Props;
}

void CMyApp::OnHelpAbout()
{ CAboutDlg dlg;
  dlg.DoModal();
}

CMyApp g_MyApp;
