#include "stdafx.h"
#include "ProgDlg.h"

COptions::COptions()
{ static TCHAR defs[16][16] =
  { _T("flee"), _T("d"), _T("s"), _T("d"), _T("w"), _T(""), _T("e"), _T("u"),
    _T("n"), _T("u"), _T(""), _T(""), _T(""), _T(""), _T("")
  };
  bConceal=bNotify=true;
  for(int i=0;i<16;i++) _tcscpy(Keypad[i], defs[i]);
}

void COptions::Load()
{ FILE *file = Open(false);
  if(!file) return;
  fread(this, sizeof(COptions), 1, file);
  fclose(file);
}

void COptions::Save()
{ FILE *file = Open(true);
  if(!file) return;
  fwrite(this, sizeof(COptions), 1, file);
  fclose(file);
}

CProgDlg::CProgDlg(COptions props) : CDialog(IDD_PRGPROPS, NULL)
{ Props = props;
}

BOOL CProgDlg::OnInitDialog()
{ GetDlgItem(IDC_CONCEAL)->SendMessage(BM_SETCHECK, Props.bConceal);
  GetDlgItem(IDC_NOTIFY)->SendMessage(BM_SETCHECK, Props.bNotify);
  for(int i=0;i<16;i++)
  { if(i==K_SEPR) continue;
    CWnd *wnd = GetDlgItem(IDC_KEYPAD0+i);
    wnd->SendMessage(EM_LIMITTEXT, 15);
    wnd->SetWindowText(Props.Keypad[i]);
  }
  return TRUE;
}

void CProgDlg::OnOK()
{ Props.bConceal = GetDlgItem(IDC_CONCEAL)->SendMessage(BM_GETCHECK) != 0;
  Props.bNotify  = GetDlgItem(IDC_NOTIFY )->SendMessage(BM_GETCHECK) != 0;
  for(int i=0;i<16;i++)
  { if(i==K_SEPR) continue;
    GetDlgItem(IDC_KEYPAD0+i)->GetWindowText(Props.Keypad[i], 16);
  }
  Props.Save();
  CDialog::OnOK();
}
